/*
 * Decompiled with CFR 0.152.
 */
package com.luhuiguo.chinese;

import com.luhuiguo.chinese.Converter;
import com.luhuiguo.chinese.pinyin.Pinyin;
import com.luhuiguo.chinese.pinyin.PinyinFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ChineseUtils {
    public static String toSimplified(String str) {
        return Converter.SIMPLIFIED.convert(str);
    }

    public static String toTraditional(String str) {
        return Converter.TRADITIONAL.convert(str);
    }

    public static String toPinyin(String str, PinyinFormat format) {
        return Pinyin.INSTANCE.convert(str, format);
    }

    public static String toPinyin(String str) {
        return Pinyin.INSTANCE.convert(str, PinyinFormat.DEFAULT_PINYIN_FORMAT);
    }

    public static void main(String[] args) {
        int mode = 0;
        String textLine = "";
        ChineseUtils.printHelp();
        ChineseUtils.printHit(mode);
        while (true) {
            if ((textLine = ChineseUtils.readInputTextLine()) == null || textLine.length() < 1) {
                ChineseUtils.printHelp();
                ChineseUtils.printHit(mode);
            }
            if ("q".equals(textLine)) {
                System.exit(0);
            } else if ("t".equals(textLine)) {
                mode = 2;
            } else if ("s".equals(textLine)) {
                mode = 1;
            } else if ("".equals(textLine)) {
                mode = 0;
            } else {
                switch (mode) {
                    case 1: {
                        System.out.println("\u7b80\u4f53: " + ChineseUtils.toSimplified(textLine));
                        break;
                    }
                    case 2: {
                        System.out.println("\u7e41\u4f53: " + ChineseUtils.toTraditional(textLine));
                        break;
                    }
                    default: {
                        System.out.println("\u62fc\u97f3: " + ChineseUtils.toPinyin(textLine) + " (" + ChineseUtils.toPinyin(textLine, PinyinFormat.UNICODE_PINYIN_FORMAT) + ")");
                    }
                }
            }
            ChineseUtils.printHit(mode);
        }
    }

    public static String readInputTextLine() {
        BufferedReader lineOfText = new BufferedReader(new InputStreamReader(System.in));
        String textLine = null;
        try {
            textLine = lineOfText.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return textLine;
    }

    public static void printHelp() {
        System.out.println("\u8bf7\u8f93\u5165\u5e0c\u671b\u8f6c\u6362\u7684\u4e2d\u6587\u6216\u8f93\u5165[q]\u9000\u51fa\u3001[s]\u8f6c\u7b80\u4f53\u3001[t]\u8f6c\u7e41\u4f53\u3001[p]\u8f6c\u62fc\u97f3\u3002");
    }

    public static void printHit(int mode) {
        switch (mode) {
            case 1: {
                System.out.print("\u8f6c\u7b80> ");
                break;
            }
            case 2: {
                System.out.print("\u8f6c\u7e41> ");
                break;
            }
            default: {
                System.out.print("\u8f6c\u62fc> ");
            }
        }
    }
}

