/*
 * Decompiled with CFR 0.152.
 */
package com.luhuiguo.chinese;

import com.luhuiguo.chinese.Trie;
import com.luhuiguo.chinese.TrieNode;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Converter {
    SIMPLIFIED(false),
    TRADITIONAL(true);

    public static final char CJK_UNIFIED_IDEOGRAPHS_START = '\u4e00';
    public static final char CJK_UNIFIED_IDEOGRAPHS_END = '\u9fa5';
    public static final String SIMPLIFIED_MAPPING_FILE = "/simp.txt";
    public static final String SIMPLIFIED_LEXEMIC_MAPPING_FILE = "/simplified.txt";
    public static final String TRADITIONAL_MAPPING_FILE = "/trad.txt";
    public static final String TRADITIONAL_LEXEMIC_MAPPING_FILE = "/traditional.txt";
    public static final String EMPTY = "";
    public static final String SHARP = "#";
    public static final String EQUAL = "=";
    private char[] chars = null;
    private Trie<String> dict = null;
    private int maxLen = 2;

    private Converter(boolean s2t) {
        this.loadCharMapping(s2t);
        this.loadLexemicMapping(s2t);
    }

    public void loadCharMapping(boolean s2t) {
        String mappingFile = SIMPLIFIED_MAPPING_FILE;
        if (s2t) {
            mappingFile = TRADITIONAL_MAPPING_FILE;
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(((Object)((Object)this)).getClass().getResourceAsStream(mappingFile)), StandardCharsets.UTF_8));
            CharArrayWriter out = new CharArrayWriter();
            String line = null;
            while (null != (line = in.readLine())) {
                out.write(line);
            }
            this.chars = out.toCharArray();
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadLexemicMapping(boolean s2t) {
        String mappingFile = SIMPLIFIED_LEXEMIC_MAPPING_FILE;
        if (s2t) {
            mappingFile = TRADITIONAL_LEXEMIC_MAPPING_FILE;
        }
        this.dict = new Trie();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(((Object)((Object)this)).getClass().getResourceAsStream(mappingFile)), StandardCharsets.UTF_8));
            String line = null;
            while (null != (line = in.readLine())) {
                String[] pair;
                if (line.length() == 0 || line.startsWith(SHARP) || (pair = line.split(EQUAL)).length < 2) continue;
                this.maxLen = this.maxLen < pair[0].length() ? pair[0].length() : this.maxLen;
                this.dict.add(pair[0], pair[1]);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public char convert(char ch) {
        if (ch >= '\u4e00' && ch <= '\u9fa5') {
            return this.chars[ch - 19968];
        }
        return ch;
    }

    public void convert(Reader reader, Writer writer) throws IOException {
        PushbackReader in = new PushbackReader(new BufferedReader(reader), this.maxLen);
        char[] buf = new char[this.maxLen];
        int len = -1;
        while ((len = in.read(buf)) != -1) {
            TrieNode<String> node = this.dict.bestMatch(buf, 0, len);
            if (node != null) {
                int offset = node.getLevel();
                writer.write(node.getValue());
                in.unread(buf, offset, len - offset);
                continue;
            }
            in.unread(buf, 0, len);
            char ch = (char)in.read();
            writer.write(this.convert(ch));
        }
    }

    public String convert(String str) {
        String ret = str;
        StringReader in = new StringReader(str);
        StringWriter out = new StringWriter();
        try {
            this.convert(in, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ret = ((Object)out).toString();
        return ret;
    }
}

