/*
 * Decompiled with CFR 0.152.
 */
package com.luhuiguo.chinese.pinyin;

import com.luhuiguo.chinese.Trie;
import com.luhuiguo.chinese.TrieNode;
import com.luhuiguo.chinese.pinyin.PinyinFormat;
import com.luhuiguo.chinese.pinyin.PinyinFormatter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Pinyin {
    INSTANCE;

    public static final String PINYIN_MAPPING_FILE = "/pinyin.txt";
    public static final String POLYPHONE_MAPPING_FILE = "/polyphone.txt";
    public static final String EMPTY = "";
    public static final String SHARP = "#";
    public static final String EQUAL = "=";
    public static final String COMMA = ",";
    public static final String SPACE = " ";
    private List<String> pinyinDict = null;
    private Trie<String> polyphoneDict = null;
    private int maxLen = 2;

    private Pinyin() {
        this.loadPinyinMapping();
        this.loadPolyphoneMapping();
    }

    public void loadPinyinMapping() {
        this.pinyinDict = new ArrayList<String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(((Object)((Object)this)).getClass().getResourceAsStream(PINYIN_MAPPING_FILE)), StandardCharsets.UTF_8));
            String line = null;
            while (null != (line = in.readLine())) {
                if (line.length() == 0 || line.startsWith(SHARP)) continue;
                String[] pair = line.split(EQUAL);
                if (pair.length < 2) {
                    this.pinyinDict.add(EMPTY);
                    continue;
                }
                this.pinyinDict.add(pair[1]);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadPolyphoneMapping() {
        this.polyphoneDict = new Trie();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(((Object)((Object)this)).getClass().getResourceAsStream(POLYPHONE_MAPPING_FILE)), StandardCharsets.UTF_8));
            String line = null;
            while (null != (line = in.readLine())) {
                String[] pair;
                if (line.length() == 0 || line.startsWith(SHARP) || (pair = line.split(EQUAL)).length < 2) continue;
                this.maxLen = this.maxLen < pair[0].length() ? pair[0].length() : this.maxLen;
                this.polyphoneDict.add(pair[0], pair[1]);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String[] toUnformattedPinyin(char ch) {
        if (ch >= '\u4e00' && ch <= '\u9fa5') {
            String pinyinStr = this.pinyinDict.get(ch - 19968);
            return pinyinStr.split(COMMA);
        }
        return null;
    }

    public String[] toFormattedPinyin(char ch, PinyinFormat format) {
        String[] pinyinStrArray = this.toUnformattedPinyin(ch);
        if (null != pinyinStrArray) {
            for (int i = 0; i < pinyinStrArray.length; ++i) {
                pinyinStrArray[i] = PinyinFormatter.formatPinyin(pinyinStrArray[i], format);
            }
            return pinyinStrArray;
        }
        return null;
    }

    public String toPinyin(char ch) {
        String[] pinyinStrArray = this.toUnformattedPinyin(ch);
        if (null != pinyinStrArray && pinyinStrArray.length > 0) {
            return pinyinStrArray[0];
        }
        return null;
    }

    public String toPinyin(char ch, PinyinFormat format) {
        String[] pinyinStrArray = null;
        pinyinStrArray = this.toFormattedPinyin(ch, format);
        if (null != pinyinStrArray && pinyinStrArray.length > 0) {
            return pinyinStrArray[0];
        }
        return null;
    }

    public void convert(Reader reader, Writer writer, PinyinFormat format) throws IOException {
        PushbackReader in = new PushbackReader(new BufferedReader(reader), this.maxLen);
        char[] buf = new char[this.maxLen];
        boolean writeSeparator = false;
        int len = -1;
        while ((len = in.read(buf)) != -1) {
            TrieNode<String> node = this.polyphoneDict.bestMatch(buf, 0, len);
            if (node != null) {
                String[] arr;
                int offset = node.getLevel();
                String str = node.getValue();
                for (String s : arr = str.split(SPACE)) {
                    String pinyinStr = PinyinFormatter.formatPinyin(s, format);
                    if (null == pinyinStr) continue;
                    if (writeSeparator) {
                        writer.write(format.getSeparator());
                    }
                    writer.write(pinyinStr);
                    writeSeparator = true;
                }
                in.unread(buf, offset, len - offset);
                continue;
            }
            in.unread(buf, 0, len);
            char ch = (char)in.read();
            String pinyinStr = this.toPinyin(ch, format);
            if (null != pinyinStr) {
                if (writeSeparator) {
                    writer.write(format.getSeparator());
                }
                writer.write(pinyinStr);
                writeSeparator = true;
                continue;
            }
            if (format.isOnlyPinyin()) continue;
            writer.write(ch);
            writeSeparator = true;
        }
    }

    public String convert(String str, PinyinFormat format) {
        String ret = str;
        StringReader in = new StringReader(str);
        StringWriter out = new StringWriter();
        try {
            this.convert(in, out, format);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ret = ((Object)out).toString();
        return ret;
    }
}

