/*
 * Decompiled with CFR 0.152.
 */
package com.luhuiguo.chinese.pinyin;

import com.luhuiguo.chinese.pinyin.PinyinFormat;
import com.luhuiguo.chinese.pinyin.ToneType;
import com.luhuiguo.chinese.pinyin.YuCharType;

public class PinyinFormatter {
    public static String formatPinyin(String pinyinStr, PinyinFormat format) {
        if (ToneType.WITH_ABBR == format.getToneType()) {
            pinyinStr = PinyinFormatter.abbr(pinyinStr);
        } else {
            if (ToneType.WITH_TONE_MARK == format.getToneType() && (YuCharType.WITH_V == format.getYuCharType() || YuCharType.WITH_U_AND_COLON == format.getYuCharType())) {
                format.setYuCharType(YuCharType.WITH_U_UNICODE);
            }
            switch (format.getToneType()) {
                case WITHOUT_TONE: {
                    pinyinStr = pinyinStr.replaceAll("[1-5]", "");
                    break;
                }
                case WITH_TONE_MARK: {
                    pinyinStr = pinyinStr.replaceAll("u:", "v");
                    pinyinStr = PinyinFormatter.convertToneNumber2ToneMark(pinyinStr);
                    break;
                }
            }
            switch (format.getYuCharType()) {
                case WITH_V: {
                    pinyinStr = pinyinStr.replaceAll("u:", "v");
                    break;
                }
                case WITH_U_UNICODE: {
                    pinyinStr = pinyinStr.replaceAll("u:", "\u00fc");
                    break;
                }
            }
        }
        switch (format.getCaseType()) {
            case UPPERCASE: {
                pinyinStr = pinyinStr.toUpperCase();
                break;
            }
            case CAPITALIZE: {
                pinyinStr = PinyinFormatter.capitalize(pinyinStr);
                break;
            }
        }
        return pinyinStr;
    }

    public static String abbr(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return str.substring(0, 1);
    }

    public static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        return new StringBuilder(strLen).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    private static String convertToneNumber2ToneMark(String pinyinStr) {
        String lowerCasePinyinStr = pinyinStr.toLowerCase();
        if (lowerCasePinyinStr.matches("[a-z]*[1-5]?")) {
            int defautlCharValue = 36;
            int defautlIndexValue = -1;
            int unmarkedVowel = 36;
            int indexOfUnmarkedVowel = -1;
            int charA = 97;
            int charE = 101;
            String ouStr = "ou";
            String allUnmarkedVowelStr = "aeiouv";
            String allMarkedVowelStr = "\u0101\u00e1\u0103\u00e0a\u0113\u00e9\u0115\u00e8e\u012b\u00ed\u012d\u00eci\u014d\u00f3\u014f\u00f2o\u016b\u00fa\u016d\u00f9u\u01d6\u01d8\u01da\u01dc\u00fc";
            if (lowerCasePinyinStr.matches("[a-z]*[1-5]")) {
                int tuneNumber = Character.getNumericValue(lowerCasePinyinStr.charAt(lowerCasePinyinStr.length() - 1));
                int indexOfA = lowerCasePinyinStr.indexOf(97);
                int indexOfE = lowerCasePinyinStr.indexOf(101);
                int ouIndex = lowerCasePinyinStr.indexOf("ou");
                if (-1 != indexOfA) {
                    indexOfUnmarkedVowel = indexOfA;
                    unmarkedVowel = 97;
                } else if (-1 != indexOfE) {
                    indexOfUnmarkedVowel = indexOfE;
                    unmarkedVowel = 101;
                } else if (-1 != ouIndex) {
                    indexOfUnmarkedVowel = ouIndex;
                    unmarkedVowel = "ou".charAt(0);
                } else {
                    for (int i = lowerCasePinyinStr.length() - 1; i >= 0; --i) {
                        if (!String.valueOf(lowerCasePinyinStr.charAt(i)).matches("[aeiouv]")) continue;
                        indexOfUnmarkedVowel = i;
                        unmarkedVowel = lowerCasePinyinStr.charAt(i);
                        break;
                    }
                }
                if (36 != unmarkedVowel && -1 != indexOfUnmarkedVowel) {
                    int rowIndex = "aeiouv".indexOf(unmarkedVowel);
                    int columnIndex = tuneNumber - 1;
                    int vowelLocation = rowIndex * 5 + columnIndex;
                    char markedVowel = "\u0101\u00e1\u0103\u00e0a\u0113\u00e9\u0115\u00e8e\u012b\u00ed\u012d\u00eci\u014d\u00f3\u014f\u00f2o\u016b\u00fa\u016d\u00f9u\u01d6\u01d8\u01da\u01dc\u00fc".charAt(vowelLocation);
                    StringBuffer resultBuffer = new StringBuffer();
                    resultBuffer.append(lowerCasePinyinStr.substring(0, indexOfUnmarkedVowel).replaceAll("v", "\u00fc"));
                    resultBuffer.append(markedVowel);
                    resultBuffer.append(lowerCasePinyinStr.substring(indexOfUnmarkedVowel + 1, lowerCasePinyinStr.length() - 1).replaceAll("v", "\u00fc"));
                    return resultBuffer.toString();
                }
                return lowerCasePinyinStr;
            }
            return lowerCasePinyinStr.replaceAll("v", "\u00fc");
        }
        return lowerCasePinyinStr;
    }
}

