/*
 * Decompiled with CFR 0.152.
 */
package com.xiaogang.xxljobadminsdk.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.PageUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xiaogang.xxljobadminsdk.config.XxlJobAdminProperties;
import com.xiaogang.xxljobadminsdk.constants.ExecutorBlockStrategyEnum;
import com.xiaogang.xxljobadminsdk.constants.ExecutorRouteStrategyEnum;
import com.xiaogang.xxljobadminsdk.constants.GlueTypeEnum;
import com.xiaogang.xxljobadminsdk.constants.MisfireStrategyEnum;
import com.xiaogang.xxljobadminsdk.constants.ScheduleTypeEnum;
import com.xiaogang.xxljobadminsdk.constants.TriggerStatusEnum;
import com.xiaogang.xxljobadminsdk.dto.HttpHeader;
import com.xiaogang.xxljobadminsdk.dto.JobGroupQuery;
import com.xiaogang.xxljobadminsdk.dto.JobQuery;
import com.xiaogang.xxljobadminsdk.dto.ReturnT;
import com.xiaogang.xxljobadminsdk.model.DefaultXxlJobAddParam;
import com.xiaogang.xxljobadminsdk.model.JobUpdateParam;
import com.xiaogang.xxljobadminsdk.model.XxlJobInfo;
import com.xiaogang.xxljobadminsdk.model.XxlJobInfoAddParam;
import com.xiaogang.xxljobadminsdk.service.XxlJobService;
import com.xiaogang.xxljobadminsdk.utils.MyUtil;
import com.xiaogang.xxljobadminsdk.vo.DataItem;
import com.xiaogang.xxljobadminsdk.vo.JobGroupPageResult;
import com.xiaogang.xxljobadminsdk.vo.JobInfoPageItem;
import com.xiaogang.xxljobadminsdk.vo.JobInfoPageResult;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class XxlJobServiceImpl
implements XxlJobService {
    private static final Logger log = LoggerFactory.getLogger(XxlJobServiceImpl.class);
    private HttpHeader loginHeader;
    private XxlJobAdminProperties xxlJobAdminProperties;
    private int timeout;

    public XxlJobServiceImpl(HttpHeader loginHeader, XxlJobAdminProperties xxlJobAdminProperties) {
        this.loginHeader = loginHeader;
        this.xxlJobAdminProperties = xxlJobAdminProperties;
        this.timeout = this.xxlJobAdminProperties.getConnectionTimeOut();
    }

    @Override
    public JobInfoPageResult pageList(JobQuery jobQuery) {
        this.validQueryParam(jobQuery);
        HttpRequest httpRequest = this.getHttpRequest("/jobinfo/pageList");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("start", jobQuery.getStart());
        paramMap.put("length", jobQuery.getLength());
        paramMap.put("jobGroup", jobQuery.getJobGroup());
        TriggerStatusEnum triggerStatus = jobQuery.getTriggerStatus();
        if (triggerStatus != null) {
            paramMap.put("triggerStatus", triggerStatus.getStatus());
        }
        paramMap.put("jobDesc", jobQuery.getJobDesc());
        paramMap.put("executorHandler", jobQuery.getExecutorHandler());
        paramMap.put("author", jobQuery.getAuthor());
        HttpResponse response = httpRequest.form(paramMap).timeout(this.timeout).execute();
        int status = response.getStatus();
        String body = response.body();
        log.debug("status:{},body:{}", (Object)status, (Object)body);
        Assert.isTrue((status == 200 ? 1 : 0) != 0, (String)body, (Object[])new Object[0]);
        JobInfoPageResult jobInfoPageResult = (JobInfoPageResult)JSON.parseObject((String)body, JobInfoPageResult.class);
        return jobInfoPageResult;
    }

    @Override
    public JobGroupPageResult pageList(JobGroupQuery jobGroupQuery) {
        this.validQueryParam(jobGroupQuery);
        HttpRequest httpRequest = this.getHttpRequest("/jobgroup/pageList");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("start", jobGroupQuery.getStart());
        paramMap.put("length", jobGroupQuery.getLength());
        paramMap.put("appname", jobGroupQuery.getAppname());
        paramMap.put("title", jobGroupQuery.getTitle());
        HttpResponse response = httpRequest.form(paramMap).timeout(this.timeout).execute();
        int status = response.getStatus();
        String body = response.body();
        log.debug("status:{},body:{}", (Object)status, (Object)body);
        Assert.isTrue((status == 200 ? 1 : 0) != 0, (String)body, (Object[])new Object[0]);
        JobGroupPageResult jobInfoPageResult = (JobGroupPageResult)JSON.parseObject((String)body, JobGroupPageResult.class);
        return jobInfoPageResult;
    }

    @Override
    public int getFirstJobGroupIdByAppName(String appName) {
        JobGroupQuery jobGroupQuery = new JobGroupQuery();
        jobGroupQuery.setStart(0);
        jobGroupQuery.setLength(1);
        jobGroupQuery.setAppname(appName);
        JobGroupPageResult jobGroupPageResult = this.pageList(jobGroupQuery);
        String errorMsgTemplate = "\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u521b\u5efa\u5bf9\u5e94\u540d\u79f0\u7684\u6267\u884c\u5668";
        Assert.notNull((Object)jobGroupPageResult, (String)errorMsgTemplate, (Object[])new Object[0]);
        List<DataItem> data = jobGroupPageResult.getData();
        Assert.isTrue((boolean)CollUtil.isNotEmpty(data), (String)errorMsgTemplate, (Object[])new Object[0]);
        DataItem dataItem = data.get(0);
        int id = dataItem.getId();
        return id;
    }

    @Override
    public int getDefaultJobGroupId() {
        String appname = this.xxlJobAdminProperties.getAppname();
        int jobGroupIdByAppName = this.getFirstJobGroupIdByAppName(appname);
        return jobGroupIdByAppName;
    }

    private void validQueryParam(JobGroupQuery jobGroupQuery) {
        int start = jobGroupQuery.getStart();
        Assert.notNull((Object)start, (String)"\u5206\u9875\u53c2\u6570start\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        int length = jobGroupQuery.getLength();
        Assert.notNull((Object)length, (String)"\u5206\u9875\u53c2\u6570length\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
    }

    private void validQueryParam(JobQuery jobQuery) {
        int jobGroup = jobQuery.getJobGroup();
        Assert.notNull((Object)jobGroup, (String)"jobGroup\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        TriggerStatusEnum triggerStatus = jobQuery.getTriggerStatus();
        Assert.notNull((Object)((Object)triggerStatus), (String)"triggerStatus\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        int start = jobQuery.getStart();
        Assert.notNull((Object)start, (String)"\u5206\u9875\u53c2\u6570start\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        int length = jobQuery.getLength();
        Assert.notNull((Object)length, (String)"\u5206\u9875\u53c2\u6570length\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
    }

    @Override
    public Integer add(XxlJobInfo jobInfo) {
        HttpRequest httpRequest = this.postHttpRequest("/jobinfo/add");
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)jobInfo));
        ReturnT<String> returnT = this.requestXxlJobAdmin(httpRequest, (Map<String, Object>)jsonObject, new TypeReference<ReturnT<String>>(){});
        return Integer.valueOf(returnT.getContent());
    }

    @Override
    public Integer add(XxlJobInfoAddParam addParam) {
        DefaultXxlJobAddParam defaultXxlJobAddParam = new DefaultXxlJobAddParam();
        BeanUtils.copyProperties((Object)addParam, (Object)defaultXxlJobAddParam);
        Integer jobId = this.add(defaultXxlJobAddParam);
        return jobId;
    }

    @Override
    public Integer addJustExecuteOnceJob(String customId, Date triggerTime, String executorParam, String executorHandler) {
        JobInfoPageItem jobInfoPageItem = this.getJobByCustomId(customId);
        Assert.isNull((Object)jobInfoPageItem, (String)"\u5df2\u7ecf\u5b58\u5728\u81ea\u5b9a\u4e49id\u4e3a{}\u7684\u4efb\u52a1\uff0c\u8bf7\u4fee\u6539", (Object[])new Object[]{customId});
        Date now = new Date();
        boolean after = triggerTime.after(now);
        Assert.isTrue((boolean)after, (String)"\u4efb\u52a1\u6267\u884c\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4", (Object[])new Object[0]);
        XxlJobInfoAddParam addParam = new XxlJobInfoAddParam();
        addParam.setJobDesc("none");
        addParam.setAuthor(customId);
        addParam.setScheduleType(ScheduleTypeEnum.CRON);
        String cron = MyUtil.getCron(triggerTime);
        addParam.setScheduleConf(cron);
        addParam.setExecutorHandler(executorHandler);
        addParam.setExecutorParam(executorParam);
        Integer jobId = this.add(addParam);
        return jobId;
    }

    @Override
    public Integer getJobIdByCustomId(String customId) {
        JobInfoPageItem jobInfoPageItem = this.getJobByCustomId(customId);
        if (jobInfoPageItem == null) {
            return null;
        }
        return jobInfoPageItem.getId();
    }

    @Override
    public JobInfoPageItem getJobByCustomId(String customId) {
        JobQuery jobQuery = new JobQuery();
        jobQuery.setStart(0);
        jobQuery.setLength(1);
        int jobGroup = this.getDefaultJobGroupId();
        jobQuery.setJobGroup(jobGroup);
        jobQuery.setTriggerStatus(TriggerStatusEnum.ALL);
        jobQuery.setAuthor(customId);
        JobInfoPageResult jobInfoPageResult = this.pageList(jobQuery);
        List<JobInfoPageItem> data = jobInfoPageResult.getData();
        if (CollUtil.isEmpty(data)) {
            return null;
        }
        JobInfoPageItem jobInfoPageItem = data.get(0);
        return jobInfoPageItem;
    }

    @Override
    public Integer add(DefaultXxlJobAddParam defaultXxlJobAddParam) {
        GlueTypeEnum glueType;
        ExecutorBlockStrategyEnum executorBlockStrategy;
        ExecutorRouteStrategyEnum executorRouteStrategy;
        MisfireStrategyEnum misfireStrategy;
        XxlJobInfo jobInfo = new XxlJobInfo();
        ScheduleTypeEnum scheduleType = defaultXxlJobAddParam.getScheduleType();
        if (scheduleType != null) {
            jobInfo.setScheduleType(scheduleType);
        }
        if ((misfireStrategy = defaultXxlJobAddParam.getMisfireStrategy()) != null) {
            jobInfo.setMisfireStrategy(misfireStrategy);
        }
        if ((executorRouteStrategy = defaultXxlJobAddParam.getExecutorRouteStrategy()) != null) {
            jobInfo.setExecutorRouteStrategy(executorRouteStrategy);
        }
        if ((executorBlockStrategy = defaultXxlJobAddParam.getExecutorBlockStrategy()) != null) {
            jobInfo.setExecutorBlockStrategy(executorBlockStrategy.name());
        }
        if ((glueType = defaultXxlJobAddParam.getGlueType()) != null) {
            jobInfo.setGlueType(glueType);
        }
        BeanUtils.copyProperties((Object)defaultXxlJobAddParam, (Object)jobInfo);
        Integer jobGroupId = this.getDefaultJobGroupId();
        jobInfo.setJobGroup(jobGroupId);
        this.validAddJobParam(jobInfo);
        Integer jobId = this.add(jobInfo);
        return jobId;
    }

    private void validAddJobParam(XxlJobInfo jobInfo) {
        Assert.notNull((Object)jobInfo, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        Assert.notNull((Object)jobInfo.getJobGroup(), (String)"jobGroup\u53c2\u6570\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        Assert.notNull((Object)jobInfo.getJobDesc(), (String)"jobDesc\u53c2\u6570\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        Assert.notNull((Object)jobInfo.getAuthor(), (String)"author\u53c2\u6570\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        Assert.notNull((Object)((Object)jobInfo.getScheduleType()), (String)"scheduleType\u53c2\u6570\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        Assert.notNull((Object)((Object)jobInfo.getGlueType()), (String)"glueType\u53c2\u6570\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        Assert.notNull((Object)jobInfo.getExecutorHandler(), (String)"executorHandler\u53c2\u6570\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
    }

    @Override
    public void update(JobUpdateParam jobInfo) {
        HttpRequest httpRequest = this.postHttpRequest("/jobinfo/update");
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)jobInfo));
        this.requestXxlJobAdmin(httpRequest, (Map<String, Object>)jsonObject, new TypeReference<ReturnT<String>>(){});
    }

    @Override
    public void update(JobInfoPageItem jobInfoPageItem) {
        JobUpdateParam xxlJobInfo = this.transform(jobInfoPageItem);
        this.update(xxlJobInfo);
    }

    @Override
    public JobUpdateParam transform(JobInfoPageItem jobInfoPageItem) {
        JobUpdateParam jobInfo = new JobUpdateParam();
        jobInfo.setScheduleConf(jobInfoPageItem.getScheduleConf());
        jobInfo.setId(jobInfoPageItem.getId());
        jobInfo.setJobGroup(jobInfoPageItem.getJobGroup());
        jobInfo.setJobDesc(jobInfoPageItem.getJobDesc());
        jobInfo.setAuthor(jobInfoPageItem.getAuthor());
        jobInfo.setAlarmEmail(jobInfoPageItem.getAlarmEmail());
        jobInfo.setScheduleType(jobInfoPageItem.getScheduleType());
        jobInfo.setMisfireStrategy(jobInfoPageItem.getMisfireStrategy());
        jobInfo.setExecutorRouteStrategy(jobInfoPageItem.getExecutorRouteStrategy());
        jobInfo.setExecutorHandler(jobInfoPageItem.getExecutorHandler());
        jobInfo.setExecutorParam(jobInfoPageItem.getExecutorParam());
        jobInfo.setExecutorBlockStrategy(jobInfoPageItem.getExecutorBlockStrategy());
        jobInfo.setExecutorTimeout(jobInfoPageItem.getExecutorTimeout());
        jobInfo.setExecutorFailRetryCount(jobInfoPageItem.getExecutorFailRetryCount());
        jobInfo.setChildJobId(jobInfoPageItem.getChildJobId());
        return jobInfo;
    }

    @Override
    public void remove(int id) {
        HttpRequest httpRequest = this.postHttpRequest("/jobinfo/remove");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        this.requestXxlJobAdmin(httpRequest, map, new TypeReference<ReturnT<String>>(){});
    }

    @Override
    public void remove(TriggerStatusEnum triggerStatus, String jobDesc, String executorHandler, String author) {
        JobQuery jobQuery = new JobQuery();
        jobQuery.setStart(0);
        jobQuery.setLength(10);
        jobQuery.setJobGroup(this.getDefaultJobGroupId());
        jobQuery.setTriggerStatus(triggerStatus);
        jobQuery.setJobDesc(jobDesc);
        jobQuery.setExecutorHandler(executorHandler);
        jobQuery.setAuthor(author);
        JobInfoPageResult jobInfoPageResult = this.pageList(jobQuery);
        List<JobInfoPageItem> data = jobInfoPageResult.getData();
        if (CollUtil.isEmpty(data)) {
            return;
        }
        for (JobInfoPageItem item : data) {
            this.remove(item.getId());
        }
        int recordsTotal = jobInfoPageResult.getRecordsTotal();
        int totalPage = PageUtil.totalPage((int)recordsTotal, (int)jobQuery.getLength());
        for (int i = 1; i < totalPage; ++i) {
            jobInfoPageResult = this.pageList(jobQuery);
            data = jobInfoPageResult.getData();
            for (JobInfoPageItem item : data) {
                this.remove(item.getId());
            }
        }
    }

    @Override
    public void start(TriggerStatusEnum triggerStatus, String jobDesc, String executorHandler, String author) {
        JobQuery jobQuery = new JobQuery();
        jobQuery.setStart(0);
        jobQuery.setLength(10);
        jobQuery.setJobGroup(this.getDefaultJobGroupId());
        jobQuery.setTriggerStatus(triggerStatus);
        jobQuery.setJobDesc(jobDesc);
        jobQuery.setExecutorHandler(executorHandler);
        jobQuery.setAuthor(author);
        JobInfoPageResult jobInfoPageResult = this.pageList(jobQuery);
        List<JobInfoPageItem> data = jobInfoPageResult.getData();
        if (CollUtil.isEmpty(data)) {
            return;
        }
        for (JobInfoPageItem item : data) {
            this.start(item.getId());
        }
        int recordsTotal = jobInfoPageResult.getRecordsTotal();
        int totalPage = PageUtil.totalPage((int)recordsTotal, (int)jobQuery.getLength());
        for (int i = 1; i < totalPage; ++i) {
            int start = PageUtil.getStart((int)i, (int)jobQuery.getLength());
            jobQuery.setStart(start);
            jobInfoPageResult = this.pageList(jobQuery);
            data = jobInfoPageResult.getData();
            for (JobInfoPageItem item : data) {
                this.start(item.getId());
            }
        }
    }

    @Override
    public void start(int id) {
        HttpRequest httpRequest = this.postHttpRequest("/jobinfo/start");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        this.requestXxlJobAdmin(httpRequest, map, new TypeReference<ReturnT<String>>(){});
    }

    @Override
    public void stop(int id) {
        HttpRequest httpRequest = this.postHttpRequest("/jobinfo/stop");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        this.requestXxlJobAdmin(httpRequest, map, new TypeReference<ReturnT<String>>(){});
    }

    @Override
    public void stop(TriggerStatusEnum triggerStatus, String jobDesc, String executorHandler, String author) {
        JobQuery jobQuery = new JobQuery();
        jobQuery.setStart(0);
        jobQuery.setLength(10);
        jobQuery.setJobGroup(this.getDefaultJobGroupId());
        jobQuery.setTriggerStatus(triggerStatus);
        jobQuery.setJobDesc(jobDesc);
        jobQuery.setExecutorHandler(executorHandler);
        jobQuery.setAuthor(author);
        JobInfoPageResult jobInfoPageResult = this.pageList(jobQuery);
        List<JobInfoPageItem> data = jobInfoPageResult.getData();
        if (CollUtil.isEmpty(data)) {
            return;
        }
        for (JobInfoPageItem item : data) {
            this.stop(item.getId());
        }
        int recordsTotal = jobInfoPageResult.getRecordsTotal();
        int totalPage = PageUtil.totalPage((int)recordsTotal, (int)jobQuery.getLength());
        for (int i = 1; i < totalPage; ++i) {
            int start = PageUtil.getStart((int)i, (int)jobQuery.getLength());
            jobQuery.setStart(start);
            jobInfoPageResult = this.pageList(jobQuery);
            data = jobInfoPageResult.getData();
            for (JobInfoPageItem item : data) {
                this.stop(item.getId());
            }
        }
    }

    @Override
    public void triggerJob(int id, String executorParam, String addressList) {
        HttpRequest httpRequest = this.postHttpRequest("/jobinfo/trigger");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("executorParam", executorParam);
        map.put("addressList", addressList);
        this.requestXxlJobAdmin(httpRequest, map, new TypeReference<ReturnT<String>>(){});
    }

    @Override
    public List<String> nextTriggerTime(String scheduleType, String scheduleConf) {
        HttpRequest httpRequest = this.getHttpRequest("/jobinfo/nextTriggerTime");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scheduleType", scheduleType);
        map.put("scheduleConf", scheduleConf);
        ReturnT<List<String>> returnT = this.requestXxlJobAdmin(httpRequest, map, new TypeReference<ReturnT<List<String>>>(){});
        return returnT.getContent();
    }

    private HttpRequest postHttpRequest(String path) {
        String url = this.xxlJobAdminProperties.getAdminUrl() + path;
        HttpRequest httpRequest = HttpRequest.post((String)url);
        httpRequest.header(this.loginHeader.getHeaderName(), this.loginHeader.getHeaderValue());
        return httpRequest;
    }

    private HttpRequest getHttpRequest(String path) {
        String url = this.xxlJobAdminProperties.getAdminUrl() + path;
        HttpRequest httpRequest = HttpRequest.get((String)url);
        httpRequest.header(this.loginHeader.getHeaderName(), this.loginHeader.getHeaderValue());
        return httpRequest;
    }

    private <T extends ReturnT> T requestXxlJobAdmin(HttpRequest httpRequest, Map<String, Object> paramMap, TypeReference<T> type) {
        HttpResponse response = httpRequest.form(paramMap).timeout(this.timeout).execute();
        int status = response.getStatus();
        String body = response.body();
        log.debug("status:{},body:{}", (Object)status, (Object)body);
        ReturnT returnT = (ReturnT)JSON.parseObject((String)body, type, (Feature[])new Feature[0]);
        Assert.isTrue((status == 200 ? 1 : 0) != 0, (String)body, (Object[])new Object[0]);
        int code = returnT.getCode();
        log.debug("returnT:{}", (Object)returnT);
        Assert.isTrue((code == 200 ? 1 : 0) != 0, (String)returnT.getMsg(), (Object[])new Object[0]);
        return (T)returnT;
    }
}

