/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.mangofactory.swagger.models.Collections;
import com.mangofactory.swagger.models.ModelContext;
import com.mangofactory.swagger.models.ModelDependencyProvider;
import com.mangofactory.swagger.models.ModelProvider;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.mangofactory.swagger.models.Types;
import com.mangofactory.swagger.models.alternates.AlternateTypeProvider;
import com.mangofactory.swagger.models.dto.Model;
import com.mangofactory.swagger.models.dto.ModelRef;
import com.mangofactory.swagger.models.dto.builder.ModelBuilder;
import com.mangofactory.swagger.models.dto.builder.ModelPropertyBuilder;
import com.mangofactory.swagger.models.property.ModelProperty;
import com.mangofactory.swagger.models.property.provider.ModelPropertiesProvider;
import com.wordnik.swagger.annotations.ApiModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class DefaultModelProvider
implements ModelProvider {
    private final TypeResolver resolver;
    private final AlternateTypeProvider alternateTypeProvider;
    private final ModelPropertiesProvider propertiesProvider;
    private final ModelDependencyProvider dependencyProvider;

    @Autowired
    public DefaultModelProvider(TypeResolver resolver, AlternateTypeProvider alternateTypeProvider, @Qualifier(value="default") ModelPropertiesProvider propertiesProvider, ModelDependencyProvider dependencyProvider) {
        this.resolver = resolver;
        this.alternateTypeProvider = alternateTypeProvider;
        this.propertiesProvider = propertiesProvider;
        this.dependencyProvider = dependencyProvider;
    }

    @Override
    public Optional<Model> modelFor(ModelContext modelContext) {
        ResolvedType propertiesHost = this.alternateTypeProvider.alternateFor(modelContext.resolvedType(this.resolver));
        if (Collections.isContainerType(propertiesHost) || propertiesHost.getErasedType().isEnum() || Types.isBaseType(Types.typeNameFor(propertiesHost.getErasedType()))) {
            return Optional.absent();
        }
        LinkedHashMap properties = Maps.newLinkedHashMap();
        for (ModelProperty modelProperty : this.properties(modelContext, propertiesHost)) {
            properties.put(modelProperty.getName(), new ModelPropertyBuilder().type(modelProperty.typeName(modelContext)).qualifiedType(modelProperty.qualifiedTypeName()).position(modelProperty.position()).required(modelProperty.isRequired()).description(modelProperty.propertyDescription()).allowableValues(modelProperty.allowableValues()).items(this.itemModelRef(modelProperty.getType())).build());
        }
        return Optional.of((Object)new ModelBuilder().id(ResolvedTypes.typeName(propertiesHost)).name(ResolvedTypes.typeName(propertiesHost)).qualifiedType(ResolvedTypes.simpleQualifiedTypeName(propertiesHost)).properties(properties).description(this.modelDescription(propertiesHost)).baseModel("").discriminator("").subTypes(new ArrayList<String>()).build());
    }

    @Override
    public Map<String, Model> dependencies(ModelContext modelContext) {
        HashMap models = Maps.newHashMap();
        for (ResolvedType resolvedType : this.dependencyProvider.dependentModels(modelContext)) {
            Optional<Model> model = this.modelFor(ModelContext.fromParent(modelContext, resolvedType));
            if (!model.isPresent()) continue;
            models.put(((Model)model.get()).getName(), model.get());
        }
        return models;
    }

    private String modelDescription(ResolvedType type) {
        ApiModel annotation = (ApiModel)AnnotationUtils.findAnnotation((Class)type.getErasedType(), ApiModel.class);
        if (annotation != null) {
            return annotation.description();
        }
        return "";
    }

    private Iterable<? extends ModelProperty> properties(ModelContext context, ResolvedType propertiesHost) {
        if (context.isReturnType()) {
            return this.propertiesProvider.propertiesForSerialization(propertiesHost);
        }
        return this.propertiesProvider.propertiesForDeserialization(propertiesHost);
    }

    private ModelRef itemModelRef(ResolvedType type) {
        if (!Collections.isContainerType(type)) {
            return null;
        }
        ResolvedType collectionElementType = Collections.collectionElementType(type);
        String elementTypeName = ResolvedTypes.typeName(collectionElementType);
        return new ModelRef(elementTypeName);
    }
}

