/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.trafficmanager.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.trafficmanager.EndpointMonitorStatus;
import com.microsoft.azure.management.trafficmanager.EndpointStatus;
import com.microsoft.azure.management.trafficmanager.EndpointType;
import com.microsoft.azure.management.trafficmanager.GeographicLocation;
import com.microsoft.azure.management.trafficmanager.TrafficManagerEndpoint;
import com.microsoft.azure.management.trafficmanager.TrafficManagerProfile;
import com.microsoft.azure.management.trafficmanager.implementation.DeleteOperationResultInner;
import com.microsoft.azure.management.trafficmanager.implementation.EndpointInner;
import com.microsoft.azure.management.trafficmanager.implementation.EndpointsInner;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerProfileImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class TrafficManagerEndpointImpl
extends ExternalChildResourceImpl<TrafficManagerEndpoint, EndpointInner, TrafficManagerProfileImpl, TrafficManagerProfile>
implements TrafficManagerEndpoint,
TrafficManagerEndpoint.Definition<TrafficManagerProfile.DefinitionStages.WithCreate>,
TrafficManagerEndpoint.UpdateDefinition<TrafficManagerProfile.Update>,
TrafficManagerEndpoint.UpdateAzureEndpoint,
TrafficManagerEndpoint.UpdateExternalEndpoint,
TrafficManagerEndpoint.UpdateNestedProfileEndpoint {
    private final EndpointsInner client;

    TrafficManagerEndpointImpl(String name, TrafficManagerProfileImpl parent, EndpointInner inner, EndpointsInner client) {
        super(name, (Object)parent, (Object)inner);
        this.client = client;
    }

    public String id() {
        return ((EndpointInner)this.inner()).id();
    }

    @Override
    public EndpointType endpointType() {
        return EndpointType.fromValue(((EndpointInner)this.inner()).type());
    }

    @Override
    public EndpointMonitorStatus monitorStatus() {
        return ((EndpointInner)this.inner()).endpointMonitorStatus();
    }

    @Override
    public boolean isEnabled() {
        return ((EndpointInner)this.inner()).endpointStatus().equals(EndpointStatus.ENABLED);
    }

    @Override
    public long routingWeight() {
        return Utils.toPrimitiveLong((Long)((EndpointInner)this.inner()).weight());
    }

    @Override
    public long routingPriority() {
        return Utils.toPrimitiveLong((Long)((EndpointInner)this.inner()).priority());
    }

    @Override
    public Set<String> geographicLocationCodes() {
        if (((EndpointInner)this.inner()).geoMapping() == null) {
            return Collections.unmodifiableSet(new HashSet());
        }
        return Collections.unmodifiableSet(new HashSet<String>(((EndpointInner)this.inner()).geoMapping()));
    }

    @Override
    public TrafficManagerEndpointImpl toResourceId(String resourceId) {
        ((EndpointInner)this.inner()).withTargetResourceId(resourceId);
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl toFqdn(String externalFqdn) {
        ((EndpointInner)this.inner()).withTarget(externalFqdn);
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl toProfile(TrafficManagerProfile nestedProfile) {
        ((EndpointInner)this.inner()).withTargetResourceId(nestedProfile.id());
        ((EndpointInner)this.inner()).withMinChildEndpoints(new Long(1L));
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl fromRegion(Region location) {
        ((EndpointInner)this.inner()).withEndpointLocation(location.toString());
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withMinimumEndpointsToEnableTraffic(int count) {
        ((EndpointInner)this.inner()).withMinChildEndpoints(new Long(count));
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withRoutingPriority(int priority) {
        ((EndpointInner)this.inner()).withPriority(new Long(priority));
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withTrafficDisabled() {
        ((EndpointInner)this.inner()).withEndpointStatus(EndpointStatus.DISABLED);
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withTrafficEnabled() {
        ((EndpointInner)this.inner()).withEndpointStatus(EndpointStatus.ENABLED);
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withRoutingWeight(int weight) {
        ((EndpointInner)this.inner()).withWeight(new Long(weight));
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withGeographicLocation(GeographicLocation geographicLocation) {
        return this.withGeographicLocation(geographicLocation.code());
    }

    @Override
    public TrafficManagerEndpointImpl withoutGeographicLocation(GeographicLocation geographicLocation) {
        return this.withoutGeographicLocation(geographicLocation.code());
    }

    @Override
    public TrafficManagerEndpointImpl withGeographicLocations(List<GeographicLocation> geographicLocations) {
        for (GeographicLocation location : geographicLocations) {
            this.withGeographicLocation(location);
        }
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withGeographicLocation(String geographicLocationCode) {
        if (((EndpointInner)this.inner()).geoMapping() == null) {
            ((EndpointInner)this.inner()).withGeoMapping(new ArrayList<String>());
        }
        boolean found = false;
        for (String locationCode : ((EndpointInner)this.inner()).geoMapping()) {
            if (!locationCode.toLowerCase().equalsIgnoreCase(geographicLocationCode.toLowerCase())) continue;
            found = true;
            break;
        }
        if (!found) {
            ((EndpointInner)this.inner()).geoMapping().add(geographicLocationCode);
        }
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withGeographicLocations(Collection<String> geographicLocationCodes) {
        for (String locationCode : geographicLocationCodes) {
            this.withGeographicLocation(locationCode);
        }
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withoutGeographicLocation(String geographicLocationCode) {
        if (((EndpointInner)this.inner()).geoMapping() == null) {
            return this;
        }
        int itemIndex = -1;
        int i = 0;
        for (String locationCode : ((EndpointInner)this.inner()).geoMapping()) {
            if (locationCode.toLowerCase().equalsIgnoreCase(geographicLocationCode.toLowerCase())) {
                itemIndex = i;
                break;
            }
            ++i;
        }
        if (itemIndex != -1) {
            ((EndpointInner)this.inner()).geoMapping().remove(itemIndex);
        }
        return this;
    }

    public Observable<TrafficManagerEndpoint> createResourceAsync() {
        final TrafficManagerEndpointImpl self = this;
        return this.client.createOrUpdateAsync(((TrafficManagerProfileImpl)this.parent()).resourceGroupName(), ((TrafficManagerProfileImpl)this.parent()).name(), this.endpointType().localName(), this.name(), (EndpointInner)this.inner()).map((Func1)new Func1<EndpointInner, TrafficManagerEndpoint>(){

            public TrafficManagerEndpoint call(EndpointInner inner) {
                self.setInner(inner);
                return self;
            }
        });
    }

    public Observable<TrafficManagerEndpoint> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public Observable<Void> deleteResourceAsync() {
        return this.client.deleteAsync(((TrafficManagerProfileImpl)this.parent()).resourceGroupName(), ((TrafficManagerProfileImpl)this.parent()).name(), this.endpointType().localName(), this.name()).map((Func1)new Func1<DeleteOperationResultInner, Void>(){

            public Void call(DeleteOperationResultInner deleteOperationResultInner) {
                return null;
            }
        });
    }

    public TrafficManagerProfileImpl attach() {
        return ((TrafficManagerProfileImpl)this.parent()).withEndpoint(this);
    }

    protected Observable<EndpointInner> getInnerAsync() {
        return this.client.getAsync(((TrafficManagerProfileImpl)this.parent()).resourceGroupName(), ((TrafficManagerProfileImpl)this.parent()).name(), this.endpointType().toString(), this.name());
    }
}

