/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.trafficmanager.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.trafficmanager.CheckProfileDnsNameAvailabilityResult;
import com.microsoft.azure.management.trafficmanager.DnsConfig;
import com.microsoft.azure.management.trafficmanager.GeographicHierarchies;
import com.microsoft.azure.management.trafficmanager.GeographicLocation;
import com.microsoft.azure.management.trafficmanager.MonitorConfig;
import com.microsoft.azure.management.trafficmanager.TrafficManagerProfile;
import com.microsoft.azure.management.trafficmanager.TrafficManagerProfiles;
import com.microsoft.azure.management.trafficmanager.implementation.CheckTrafficManagerRelativeDnsNameAvailabilityParametersInner;
import com.microsoft.azure.management.trafficmanager.implementation.EndpointInner;
import com.microsoft.azure.management.trafficmanager.implementation.GeographicHierarchiesImpl;
import com.microsoft.azure.management.trafficmanager.implementation.ProfileInner;
import com.microsoft.azure.management.trafficmanager.implementation.ProfilesInner;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManager;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerManagementClientImpl;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerNameAvailabilityInner;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerProfileImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.ArrayList;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class TrafficManagerProfilesImpl
extends TopLevelModifiableResourcesImpl<TrafficManagerProfile, TrafficManagerProfileImpl, ProfileInner, ProfilesInner, TrafficManager>
implements TrafficManagerProfiles {
    private GeographicHierarchies geographicHierarchies;

    TrafficManagerProfilesImpl(TrafficManager trafficManager) {
        super((InnerSupportsListing)((TrafficManagerManagementClientImpl)((Object)trafficManager.inner())).profiles(), (ManagerBase)trafficManager);
        this.geographicHierarchies = new GeographicHierarchiesImpl(trafficManager, ((TrafficManagerManagementClientImpl)((Object)trafficManager.inner())).geographicHierarchies());
    }

    @Override
    public CheckProfileDnsNameAvailabilityResult checkDnsNameAvailability(String dnsNameLabel) {
        return (CheckProfileDnsNameAvailabilityResult)this.checkDnsNameAvailabilityAsync(dnsNameLabel).toBlocking().last();
    }

    @Override
    public Observable<CheckProfileDnsNameAvailabilityResult> checkDnsNameAvailabilityAsync(String dnsNameLabel) {
        CheckTrafficManagerRelativeDnsNameAvailabilityParametersInner parameter = new CheckTrafficManagerRelativeDnsNameAvailabilityParametersInner().withName(dnsNameLabel).withType("Microsoft.Network/trafficManagerProfiles");
        return ((ProfilesInner)this.inner()).checkTrafficManagerRelativeDnsNameAvailabilityAsync(parameter).map((Func1)new Func1<TrafficManagerNameAvailabilityInner, CheckProfileDnsNameAvailabilityResult>(){

            public CheckProfileDnsNameAvailabilityResult call(TrafficManagerNameAvailabilityInner trafficManagerNameAvailabilityInner) {
                return new CheckProfileDnsNameAvailabilityResult(trafficManagerNameAvailabilityInner);
            }
        });
    }

    @Override
    public ServiceFuture<CheckProfileDnsNameAvailabilityResult> checkDnsNameAvailabilityAsync(String dnsNameLabel, ServiceCallback<CheckProfileDnsNameAvailabilityResult> callback) {
        return ServiceFuture.fromBody(this.checkDnsNameAvailabilityAsync(dnsNameLabel), callback);
    }

    @Override
    public GeographicLocation getGeographicHierarchyRoot() {
        return this.geographicHierarchies.getRoot();
    }

    protected TrafficManagerProfileImpl wrapModel(String name) {
        return new TrafficManagerProfileImpl(name, new ProfileInner(), (TrafficManager)this.manager());
    }

    protected TrafficManagerProfileImpl wrapModel(ProfileInner inner) {
        if (inner == null) {
            return null;
        }
        return new TrafficManagerProfileImpl(inner.name(), inner, (TrafficManager)this.manager());
    }

    public TrafficManagerProfileImpl define(String name) {
        return this.setDefaults(this.wrapModel(name));
    }

    private TrafficManagerProfileImpl setDefaults(TrafficManagerProfileImpl profile) {
        ((ProfileInner)((Object)profile.inner())).withMonitorConfig(new MonitorConfig());
        profile.withHttpMonitoring();
        ((ProfileInner)((Object)profile.inner())).withDnsConfig(new DnsConfig());
        profile.withTimeToLive(300);
        ((ProfileInner)((Object)profile.inner())).withLocation("global");
        ((ProfileInner)((Object)profile.inner())).withEndpoints(new ArrayList<EndpointInner>());
        return profile;
    }
}

