/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushamp.internal;

import android.annotation.SuppressLint;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import com.moengage.core.internal.SdkInstanceManager;
import com.moengage.core.internal.executor.Job;
import com.moengage.core.internal.global.GlobalResources;
import com.moengage.core.internal.global.GlobalState;
import com.moengage.core.internal.logger.Logger;
import com.moengage.core.internal.model.JobMeta;
import com.moengage.core.internal.model.MoEJobParameters;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.utils.CoreUtils;
import com.moengage.core.internal.utils.TimeUtilsKt;
import com.moengage.pushamp.internal.BackgroundSyncManager;
import com.moengage.pushamp.internal.PushAmpInstanceProvider;
import com.moengage.pushamp.internal.PushAmpSyncJob;
import com.moengage.pushamp.internal.UtilsKt;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0003J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/moengage/pushamp/internal/BackgroundSyncManager;", "", "()V", "lock", "tag", "", "onBackgroundSync", "", "context", "Landroid/content/Context;", "jobParameters", "Lcom/moengage/core/internal/model/MoEJobParameters;", "scheduleBackgroundSync", "scheduleSyncJob", "minimumDelayDuration", "", "syncCampaigns", "push-amp_release"})
public final class BackgroundSyncManager {
    @NotNull
    public static final BackgroundSyncManager INSTANCE = new BackgroundSyncManager();
    @NotNull
    private static final String tag = "PushAmp_4.5.0_BackgroundSyncManager";
    @NotNull
    private static final Object lock = new Object();

    private BackgroundSyncManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void scheduleBackgroundSync(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = lock;
        synchronized (object) {
            boolean bl = false;
            try {
                Map allInstances = SdkInstanceManager.INSTANCE.getAllInstances();
                if (!UtilsKt.isFeatureEnabledForAnyInstance(context, allInstances)) {
                    return;
                }
                INSTANCE.scheduleSyncJob(context, UtilsKt.getBackgroundSyncInterval(allInstances));
            }
            catch (Exception e) {
                Logger.Companion.print(1, (Throwable)e, (Function0)scheduleBackgroundSync.1.1.INSTANCE);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private final void scheduleSyncJob(Context context, long minimumDelayDuration) {
        Logger.Companion.print$default((Logger.Companion)Logger.Companion, (int)0, null, (Function0)scheduleSyncJob.1.INSTANCE, (int)3, null);
        ComponentName serviceComponent = new ComponentName(context, PushAmpSyncJob.class);
        JobInfo.Builder builder = new JobInfo.Builder(20002, serviceComponent);
        builder.setOverrideDeadline(TimeUtilsKt.currentMillis() + minimumDelayDuration + (long)3600000);
        builder.setMinimumLatency(minimumDelayDuration);
        builder.setRequiredNetworkType(1);
        if (CoreUtils.hasPermission((Context)context, (String)"android.permission.RECEIVE_BOOT_COMPLETED")) {
            builder.setPersisted(true);
        }
        Object object = context.getSystemService("jobscheduler");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.job.JobScheduler");
        }
        JobScheduler jobScheduler = (JobScheduler)object;
        int result = jobScheduler.schedule(builder.build());
        Logger.Companion.print$default((Logger.Companion)Logger.Companion, (int)0, null, (Function0)((Function0)new Function0<String>(result){
            final /* synthetic */ int $result;
            {
                this.$result = $result;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return BackgroundSyncManager.access$getTag$p() + " scheduleSyncJob() : Schedule Result " + this.$result;
            }
        }), (int)3, null);
    }

    public final void onBackgroundSync(@NotNull Context context, @NotNull MoEJobParameters jobParameters) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)jobParameters, (String)"jobParameters");
        Runnable runnable = () -> BackgroundSyncManager.onBackgroundSync$lambda-1(context, jobParameters);
        GlobalResources.INSTANCE.getExecutor().submit(runnable);
    }

    private final void syncCampaigns(Context context) {
        Map instances = SdkInstanceManager.INSTANCE.getAllInstances();
        CountDownLatch countDownLatch = new CountDownLatch(instances.size());
        for (SdkInstance instance : instances.values()) {
            instance.getTaskHandler().submit(new Job("PUSH_AMP_BACKGROUND_DATA_SYNC", true, () -> BackgroundSyncManager.syncCampaigns$lambda-2(instance, context, countDownLatch)));
        }
        countDownLatch.await();
    }

    private static final void onBackgroundSync$lambda-1(Context $context, MoEJobParameters $jobParameters) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$jobParameters, (String)"$jobParameters");
        INSTANCE.syncCampaigns($context);
        INSTANCE.scheduleBackgroundSync($context);
        $jobParameters.getJobCompleteListener().jobComplete(new JobMeta($jobParameters.getJobParameters(), false));
    }

    private static final void syncCampaigns$lambda-2(SdkInstance $instance, Context $context, CountDownLatch $countDownLatch) {
        Intrinsics.checkNotNullParameter((Object)$instance, (String)"$instance");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$countDownLatch, (String)"$countDownLatch");
        if (!GlobalState.INSTANCE.isForeground()) {
            PushAmpInstanceProvider.INSTANCE.getControllerForInstance($instance).onBackgroundSync($context);
        }
        $countDownLatch.countDown();
    }

    public static final /* synthetic */ String access$getTag$p() {
        return tag;
    }
}

