/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushamp.internal;

import android.content.Context;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.utils.CoreUtils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0000\u001a$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0000\u00a8\u0006\n"}, d2={"getBackgroundSyncInterval", "", "sdkInstances", "", "", "Lcom/moengage/core/internal/model/SdkInstance;", "isFeatureEnabledForAnyInstance", "", "context", "Landroid/content/Context;", "push-amp_release"})
public final class UtilsKt {
    public static final long getBackgroundSyncInterval(@NotNull Map<String, SdkInstance> sdkInstances) {
        Intrinsics.checkNotNullParameter(sdkInstances, (String)"sdkInstances");
        long syncInterval = 0L;
        for (SdkInstance instance : sdkInstances.values()) {
            long l = instance.getRemoteConfig().getPushConfig().getPushAmpSyncInterval();
            syncInterval = Math.max(syncInterval, l);
        }
        return syncInterval;
    }

    public static final boolean isFeatureEnabledForAnyInstance(@NotNull Context context, @NotNull Map<String, SdkInstance> sdkInstances) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sdkInstances, (String)"sdkInstances");
        boolean isInstanceEnabled = CoreUtils.isAnyInstanceEnabled((Context)context, sdkInstances);
        boolean isFeatureEnabled = false;
        for (SdkInstance instance : sdkInstances.values()) {
            isFeatureEnabled |= instance.getRemoteConfig().getModuleStatus().isPushAmpEnabled();
        }
        return isInstanceEnabled && isFeatureEnabled;
    }
}

