/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushamp.internal.repository;

import com.moengage.core.internal.exception.NetworkRequestDisabledException;
import com.moengage.core.internal.exception.NetworkRequestFailedException;
import com.moengage.core.internal.model.NetworkResult;
import com.moengage.core.internal.model.ResultFailure;
import com.moengage.core.internal.model.ResultSuccess;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.model.network.BaseRequest;
import com.moengage.core.internal.utils.TimeUtilsKt;
import com.moengage.pushamp.internal.model.CampaignData;
import com.moengage.pushamp.internal.model.PushAmpSyncRequest;
import com.moengage.pushamp.internal.repository.local.LocalRepository;
import com.moengage.pushamp.internal.repository.remote.RemoteRepository;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\b\u001a\u00020\tH\u0096\u0001J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u0096\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\b\u0010\u0016\u001a\u00020\rH\u0002J\t\u0010\u0017\u001a\u00020\rH\u0096\u0001J\t\u0010\u0018\u001a\u00020\rH\u0096\u0001J\u0011\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0015H\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/moengage/pushamp/internal/repository/PushAmpRepository;", "Lcom/moengage/pushamp/internal/repository/local/LocalRepository;", "Lcom/moengage/pushamp/internal/repository/remote/RemoteRepository;", "localRepository", "remoteRepository", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "(Lcom/moengage/pushamp/internal/repository/local/LocalRepository;Lcom/moengage/pushamp/internal/repository/remote/RemoteRepository;Lcom/moengage/core/internal/model/SdkInstance;)V", "clearData", "", "fetchCampaigns", "Lcom/moengage/pushamp/internal/model/CampaignData;", "fromAppOpen", "", "fetchCampaignsFromServer", "Lcom/moengage/core/internal/model/NetworkResult;", "request", "Lcom/moengage/pushamp/internal/model/PushAmpSyncRequest;", "getBaseRequest", "Lcom/moengage/core/internal/model/network/BaseRequest;", "getLastSyncTime", "", "isModuleEnabled", "isSdkEnabled", "isStorageAndAPICallEnabled", "storeLastSyncTime", "lastSyncTime", "push-amp_release"})
public final class PushAmpRepository
implements LocalRepository,
RemoteRepository {
    @NotNull
    private final LocalRepository localRepository;
    @NotNull
    private final RemoteRepository remoteRepository;
    @NotNull
    private final SdkInstance sdkInstance;

    public PushAmpRepository(@NotNull LocalRepository localRepository, @NotNull RemoteRepository remoteRepository, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)localRepository, (String)"localRepository");
        Intrinsics.checkNotNullParameter((Object)remoteRepository, (String)"remoteRepository");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        this.localRepository = localRepository;
        this.remoteRepository = remoteRepository;
        this.sdkInstance = sdkInstance;
    }

    @Override
    public void clearData() {
        this.localRepository.clearData();
    }

    @Override
    @NotNull
    public BaseRequest getBaseRequest() {
        return this.localRepository.getBaseRequest();
    }

    @Override
    public long getLastSyncTime() {
        return this.localRepository.getLastSyncTime();
    }

    @Override
    public boolean isSdkEnabled() {
        return this.localRepository.isSdkEnabled();
    }

    @Override
    public boolean isStorageAndAPICallEnabled() {
        return this.localRepository.isStorageAndAPICallEnabled();
    }

    @Override
    public void storeLastSyncTime(long lastSyncTime) {
        this.localRepository.storeLastSyncTime(lastSyncTime);
    }

    @Override
    @NotNull
    public NetworkResult fetchCampaignsFromServer(@NotNull PushAmpSyncRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        return this.remoteRepository.fetchCampaignsFromServer(request);
    }

    private final boolean isModuleEnabled() {
        return this.isSdkEnabled() && this.sdkInstance.getRemoteConfig().isAppEnabled() && this.sdkInstance.getRemoteConfig().getModuleStatus().isPushAmpEnabled() && this.isStorageAndAPICallEnabled();
    }

    @NotNull
    public final CampaignData fetchCampaigns(boolean fromAppOpen) {
        if (!this.isModuleEnabled()) {
            throw new NetworkRequestDisabledException("Account/SDK/Feature disabled.");
        }
        NetworkResult networkResult = this.fetchCampaignsFromServer(new PushAmpSyncRequest(this.getBaseRequest(), this.getLastSyncTime(), fromAppOpen));
        NetworkResult networkResult2 = networkResult;
        if (networkResult2 instanceof ResultSuccess) {
            this.storeLastSyncTime(TimeUtilsKt.currentMillis());
            Object object = ((ResultSuccess)networkResult).getData();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.moengage.pushamp.internal.model.CampaignData");
            }
            return (CampaignData)object;
        }
        if (networkResult2 instanceof ResultFailure) {
            throw new NetworkRequestFailedException("API Sync Failed");
        }
        throw new NoWhenBranchMatchedException();
    }
}

