/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushamp.internal.repository.local;

import android.content.Context;
import com.moengage.core.internal.CoreInternalHelper;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.model.database.DataAccessor;
import com.moengage.core.internal.model.network.BaseRequest;
import com.moengage.core.internal.utils.RestUtilKt;
import com.moengage.pushamp.internal.repository.local.LocalRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/moengage/pushamp/internal/repository/local/LocalRepositoryImpl;", "Lcom/moengage/pushamp/internal/repository/local/LocalRepository;", "context", "Landroid/content/Context;", "dataAccessor", "Lcom/moengage/core/internal/model/database/DataAccessor;", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "(Landroid/content/Context;Lcom/moengage/core/internal/model/database/DataAccessor;Lcom/moengage/core/internal/model/SdkInstance;)V", "clearData", "", "getBaseRequest", "Lcom/moengage/core/internal/model/network/BaseRequest;", "getLastSyncTime", "", "isSdkEnabled", "", "isStorageAndAPICallEnabled", "storeLastSyncTime", "lastSyncTime", "push-amp_release"})
public final class LocalRepositoryImpl
implements LocalRepository {
    @NotNull
    private final Context context;
    @NotNull
    private final DataAccessor dataAccessor;
    @NotNull
    private final SdkInstance sdkInstance;

    public LocalRepositoryImpl(@NotNull Context context, @NotNull DataAccessor dataAccessor, @NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dataAccessor, (String)"dataAccessor");
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        this.context = context;
        this.dataAccessor = dataAccessor;
        this.sdkInstance = sdkInstance;
    }

    @Override
    public void storeLastSyncTime(long lastSyncTime) {
        this.dataAccessor.getPreference().putLong("last_message_sync", lastSyncTime);
    }

    @Override
    public long getLastSyncTime() {
        return this.dataAccessor.getPreference().getLong("last_message_sync", 0L);
    }

    @Override
    @NotNull
    public BaseRequest getBaseRequest() {
        return RestUtilKt.getBaseRequest((Context)this.context, (SdkInstance)this.sdkInstance);
    }

    @Override
    public void clearData() {
        this.dataAccessor.getPreference().removeKey("last_message_sync");
    }

    @Override
    public boolean isSdkEnabled() {
        return CoreInternalHelper.INSTANCE.getSdkStatus(this.context, this.sdkInstance).isEnabled();
    }

    @Override
    public boolean isStorageAndAPICallEnabled() {
        return CoreInternalHelper.INSTANCE.isStorageAndAPICallEnabled(this.context, this.sdkInstance);
    }
}

