/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.pushamp.internal.repository.remote;

import androidx.annotation.VisibleForTesting;
import com.moengage.core.internal.model.NetworkResult;
import com.moengage.core.internal.model.ResultFailure;
import com.moengage.core.internal.model.ResultSuccess;
import com.moengage.core.internal.model.SdkInstance;
import com.moengage.core.internal.rest.NetworkResponse;
import com.moengage.core.internal.rest.ResponseFailure;
import com.moengage.core.internal.rest.ResponseSuccess;
import com.moengage.pushamp.internal.model.CampaignData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/moengage/pushamp/internal/repository/remote/ResponseParser;", "", "sdkInstance", "Lcom/moengage/core/internal/model/SdkInstance;", "(Lcom/moengage/core/internal/model/SdkInstance;)V", "tag", "", "jsonPayloadToMap", "", "payload", "Lorg/json/JSONObject;", "isAppOpen", "", "jsonToMap", "", "payloadJson", "parseSyncResponse", "Lcom/moengage/core/internal/model/NetworkResult;", "response", "Lcom/moengage/core/internal/rest/NetworkResponse;", "processSuccessResponse", "Lcom/moengage/pushamp/internal/model/CampaignData;", "responseBody", "processSuccessResponse$push_amp_release", "push-amp_release"})
public final class ResponseParser {
    @NotNull
    private final SdkInstance sdkInstance;
    @NotNull
    private final String tag;

    public ResponseParser(@NotNull SdkInstance sdkInstance) {
        Intrinsics.checkNotNullParameter((Object)sdkInstance, (String)"sdkInstance");
        this.sdkInstance = sdkInstance;
        this.tag = "PushAmp_4.5.0_ResponseParser";
    }

    @NotNull
    public final NetworkResult parseSyncResponse(@NotNull NetworkResponse response) {
        NetworkResult networkResult;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        NetworkResponse networkResponse = response;
        if (networkResponse instanceof ResponseSuccess) {
            networkResult = (NetworkResult)new ResultSuccess((Object)this.processSuccessResponse$push_amp_release(((ResponseSuccess)response).getData()));
        } else if (networkResponse instanceof ResponseFailure) {
            networkResult = (NetworkResult)new ResultFailure(null, 1, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return networkResult;
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final CampaignData processSuccessResponse$push_amp_release(@NotNull String responseBody) {
        Intrinsics.checkNotNullParameter((Object)responseBody, (String)"responseBody");
        try {
            if (StringsKt.isBlank((CharSequence)responseBody)) {
                return new CampaignData(CollectionsKt.emptyList());
            }
            JSONObject responseJson = new JSONObject(responseBody);
            boolean isAppOpen = responseJson.optBoolean("on_app_open", false);
            if (!responseJson.has("messagesInfo")) {
                return new CampaignData(CollectionsKt.emptyList());
            }
            JSONArray payloads = responseJson.getJSONArray("messagesInfo");
            ArrayList<Map<String, String>> campaigns = new ArrayList<Map<String, String>>(payloads.length());
            int n = 0;
            int n2 = payloads.length();
            while (n < n2) {
                int i = n++;
                try {
                    JSONObject jsonPayload = payloads.getJSONObject(i);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonPayload, (String)"jsonPayload");
                    campaigns.add(this.jsonPayloadToMap(jsonPayload, isAppOpen));
                }
                catch (Exception e) {
                    this.sdkInstance.logger.log(1, (Throwable)e, (Function0)new Function0<String>(this){
                        final /* synthetic */ ResponseParser this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return Intrinsics.stringPlus((String)ResponseParser.access$getTag$p(this.this$0), (Object)" parseSyncResponse() : ");
                        }
                    });
                }
            }
            return new CampaignData((List<? extends Map<String, String>>)campaigns);
        }
        catch (Exception e) {
            this.sdkInstance.logger.log(1, (Throwable)e, (Function0)new Function0<String>(this){
                final /* synthetic */ ResponseParser this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return Intrinsics.stringPlus((String)ResponseParser.access$getTag$p(this.this$0), (Object)" processSuccessResponse() : ");
                }
            });
            return new CampaignData(CollectionsKt.emptyList());
        }
    }

    private final Map<String, String> jsonPayloadToMap(JSONObject payload, boolean isAppOpen) {
        if (!payload.has("data")) {
            return MapsKt.emptyMap();
        }
        JSONObject payloadJson = payload.getJSONObject("data");
        Intrinsics.checkNotNullExpressionValue((Object)payloadJson, (String)"payloadJson");
        Map<String, String> payloadMap = this.jsonToMap(payloadJson);
        payloadMap.put("moe_push_source", "remote_inbox");
        payloadMap.put("from_appOpen", String.valueOf(isAppOpen));
        return payloadMap;
    }

    private final Map<String, String> jsonToMap(JSONObject payloadJson) throws JSONException {
        Map map = new HashMap(payloadJson.length());
        Iterator iterator = payloadJson.keys();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String key = (String)e;
            String value = payloadJson.getString(key);
            Map map2 = map;
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            String string = value;
            map2.put(key, string);
        }
        return map;
    }

    public static final /* synthetic */ String access$getTag$p(ResponseParser $this) {
        return $this.tag;
    }
}

