/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.skip;

import com.moilioncircle.redis.replicator.Constants;
import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.event.Event;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.DefaultRdbVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.ContextKeyValuePair;
import com.moilioncircle.redis.replicator.rdb.datatype.DB;
import com.moilioncircle.redis.replicator.rdb.datatype.Module;
import com.moilioncircle.redis.replicator.rdb.module.ModuleParser;
import com.moilioncircle.redis.replicator.rdb.skip.SkipRdbParser;
import java.io.IOException;
import java.util.NoSuchElementException;

public class SkipRdbVisitor
extends DefaultRdbVisitor {
    public SkipRdbVisitor(Replicator replicator) {
        super(replicator);
    }

    @Override
    public DB applySelectDB(RedisInputStream in, int version) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadLen();
        return null;
    }

    @Override
    public DB applyResizeDB(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadLen();
        parser.rdbLoadLen();
        return null;
    }

    @Override
    public Event applyExpireTime(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadTime();
        int type = this.applyType(in);
        context.setValueRdbType(type);
        if (type == 249) {
            this.applyFreq(in, version, context);
        } else if (type == 248) {
            this.applyIdle(in, version, context);
        } else {
            this.rdbLoadObject(in, version, context);
        }
        return null;
    }

    @Override
    public Event applyExpireTimeMs(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadMillisecondTime();
        int type = this.applyType(in);
        context.setValueRdbType(type);
        if (type == 249) {
            this.applyFreq(in, version, context);
        } else if (type == 248) {
            this.applyIdle(in, version, context);
        } else {
            this.rdbLoadObject(in, version, context);
        }
        return null;
    }

    @Override
    public Event applyFreq(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        in.read();
        int valueType = this.applyType(in);
        context.setValueRdbType(valueType);
        this.rdbLoadObject(in, version, context);
        return null;
    }

    @Override
    public Event applyIdle(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadLen();
        int valueType = this.applyType(in);
        context.setValueRdbType(valueType);
        this.rdbLoadObject(in, version, context);
        return null;
    }

    @Override
    public Event applyAux(RedisInputStream in, int version) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadEncodedStringObject();
        parser.rdbLoadEncodedStringObject();
        return null;
    }

    @Override
    public Event applyModuleAux(RedisInputStream in, int version) throws IOException {
        return super.applyModuleAux(in, version);
    }

    @Override
    public Event applyString(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadEncodedStringObject();
        parser.rdbLoadEncodedStringObject();
        return null;
    }

    @Override
    public Event applyList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadEncodedStringObject();
        for (long len = parser.rdbLoadLen().len; len > 0L; --len) {
            parser.rdbLoadEncodedStringObject();
        }
        return null;
    }

    @Override
    public Event applySet(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadEncodedStringObject();
        for (long len = parser.rdbLoadLen().len; len > 0L; --len) {
            parser.rdbLoadEncodedStringObject();
        }
        return null;
    }

    @Override
    public Event applyZSet(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadEncodedStringObject();
        for (long len = parser.rdbLoadLen().len; len > 0L; --len) {
            parser.rdbLoadEncodedStringObject();
            parser.rdbLoadDoubleValue();
        }
        return null;
    }

    @Override
    public Event applyZSet2(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadEncodedStringObject();
        for (long len = parser.rdbLoadLen().len; len > 0L; --len) {
            parser.rdbLoadEncodedStringObject();
            parser.rdbLoadBinaryDoubleValue();
        }
        return null;
    }

    @Override
    public Event applyHash(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadEncodedStringObject();
        for (long len = parser.rdbLoadLen().len; len > 0L; --len) {
            parser.rdbLoadEncodedStringObject();
            parser.rdbLoadEncodedStringObject();
        }
        return null;
    }

    @Override
    public Event applyHashZipMap(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadEncodedStringObject();
        parser.rdbLoadPlainStringObject();
        return null;
    }

    @Override
    public Event applyListZipList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadEncodedStringObject();
        parser.rdbLoadPlainStringObject();
        return null;
    }

    @Override
    public Event applySetIntSet(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadEncodedStringObject();
        parser.rdbLoadPlainStringObject();
        return null;
    }

    @Override
    public Event applyZSetZipList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadEncodedStringObject();
        parser.rdbLoadPlainStringObject();
        return null;
    }

    @Override
    public Event applyHashZipList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadEncodedStringObject();
        parser.rdbLoadPlainStringObject();
        return null;
    }

    @Override
    public Event applyListQuickList(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadEncodedStringObject();
        long len = parser.rdbLoadLen().len;
        for (long i = 0L; i < len; ++i) {
            parser.rdbGenericLoadStringObject();
        }
        return null;
    }

    @Override
    public Event applyModule(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadEncodedStringObject();
        char[] c = new char[9];
        long moduleid = parser.rdbLoadLen().len;
        for (int i = 0; i < c.length; ++i) {
            c[i] = Constants.MODULE_SET[(int)(moduleid >>> 10 + (c.length - 1 - i) * 6 & 0x3FL)];
        }
        String moduleName = new String(c);
        int moduleVersion = (int)(moduleid & 0x3FFL);
        ModuleParser<? extends Module> moduleParser = this.lookupModuleParser(moduleName, moduleVersion);
        if (moduleParser == null) {
            throw new NoSuchElementException("module parser[" + moduleName + ", " + moduleVersion + "] not register. rdb type: [RDB_TYPE_MODULE]");
        }
        moduleParser.parse(in, 1);
        return null;
    }

    @Override
    public Event applyModule2(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadEncodedStringObject();
        char[] c = new char[9];
        long moduleid = parser.rdbLoadLen().len;
        for (int i = 0; i < c.length; ++i) {
            c[i] = Constants.MODULE_SET[(int)(moduleid >>> 10 + (c.length - 1 - i) * 6 & 0x3FL)];
        }
        String moduleName = new String(c);
        int moduleVersion = (int)(moduleid & 0x3FFL);
        ModuleParser<? extends Module> moduleParser = this.lookupModuleParser(moduleName, moduleVersion);
        if (moduleParser == null) {
            SkipRdbParser skipRdbParser = new SkipRdbParser(in);
            skipRdbParser.rdbLoadCheckModuleValue();
        } else {
            moduleParser.parse(in, 2);
            long eof = parser.rdbLoadLen().len;
            if (eof != 0L) {
                throw new UnsupportedOperationException("The RDB file contains module data for the module '" + moduleName + "' that is not terminated by the proper module value EOF marker");
            }
        }
        return null;
    }

    @Override
    public Event applyStreamListPacks(RedisInputStream in, int version, ContextKeyValuePair context) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadEncodedStringObject();
        long listPacks = parser.rdbLoadLen().len;
        while (listPacks-- > 0L) {
            parser.rdbLoadPlainStringObject();
            parser.rdbLoadPlainStringObject();
        }
        parser.rdbLoadLen();
        parser.rdbLoadLen();
        parser.rdbLoadLen();
        long groupCount = parser.rdbLoadLen().len;
        while (groupCount-- > 0L) {
            parser.rdbLoadPlainStringObject();
            parser.rdbLoadLen();
            parser.rdbLoadLen();
            long groupPel = parser.rdbLoadLen().len;
            while (groupPel-- > 0L) {
                in.skip(16L);
                parser.rdbLoadMillisecondTime();
                parser.rdbLoadLen();
            }
            long consumerCount = parser.rdbLoadLen().len;
            while (consumerCount-- > 0L) {
                parser.rdbLoadPlainStringObject();
                parser.rdbLoadMillisecondTime();
                long consumerPel = parser.rdbLoadLen().len;
                while (consumerPel-- > 0L) {
                    in.skip(16L);
                }
            }
        }
        return null;
    }
}

