/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.binary;

import com.mzlion.core.exceptions.DecodeException;
import com.mzlion.core.lang.Assert;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class Hex {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Hex() {
        throw new UnsupportedOperationException();
    }

    public static String encode2String(byte[] data) {
        return new String(Hex.encode(data));
    }

    public static char[] encode(byte[] data) {
        return Hex.encode(data, true);
    }

    public static char[] encode(byte[] data, boolean toLowerCase) {
        return Hex.doEncode(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static String decode2String(String data) {
        return Hex.decode2String(data, StandardCharsets.UTF_8);
    }

    public static String decode2String(String data, Charset encoding) {
        byte[] decode = Hex.decode(data);
        return new String(decode, encoding);
    }

    public static byte[] decode(String data) {
        Assert.hasLength(data, "Data must not be null.");
        return Hex.decode(data.toCharArray());
    }

    public static byte[] decode(char[] data) {
        return Hex.doDecode(data);
    }

    private static char[] doEncode(byte[] data, char[] digits) {
        int length = data.length;
        char[] out = new char[length << 1];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            out[j++] = digits[(0xF0 & data[i]) >>> 4];
            out[j++] = digits[0xF & data[i]];
        }
        return out;
    }

    private static byte[] doDecode(char[] data) {
        int length = data.length;
        if ((length & 1) != 0) {
            throw new DecodeException("Odd number of characters.");
        }
        byte[] out = new byte[length >> 1];
        int i = 0;
        int j = 0;
        while (j < length) {
            int temp = Hex.toDigit(data[j], j) << 4;
            temp |= Hex.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(temp & 0xFF);
            ++i;
        }
        return out;
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new DecodeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }
}

