/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.json.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.mzlion.core.json.TypeRef;
import com.mzlion.core.lang.ArrayUtils;
import com.mzlion.core.lang.Assert;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    private JsonUtil() {
        throw new UnsupportedOperationException();
    }

    public static <T> String toJson(T value) {
        return JsonUtil.toJson(value, true, new String[0]);
    }

    public static <T> String toJson(T value, String ... propertyNames) {
        return JsonUtil.toJson(value, true, propertyNames);
    }

    public static <T> String toJson(T value, boolean toUnicode, final String ... propertyNames) {
        if (value == null) {
            return null;
        }
        ArrayList<SerializerFeature> serializerFeatureList = new ArrayList<SerializerFeature>();
        serializerFeatureList.add(SerializerFeature.DisableCircularReferenceDetect);
        if (toUnicode) {
            serializerFeatureList.add(SerializerFeature.BrowserCompatible);
        }
        SerializerFeature[] serializerFeatures = new SerializerFeature[serializerFeatureList.size()];
        serializerFeatureList.toArray(serializerFeatures);
        if (ArrayUtils.isEmpty(propertyNames)) {
            return JSON.toJSONString(value, (SerializerFeature[])serializerFeatures);
        }
        return JSON.toJSONString(value, (SerializeFilter)new PropertyFilter(){

            public boolean apply(Object object, String name, Object value) {
                return !ArrayUtils.containsElement(propertyNames, name);
            }
        }, (SerializerFeature[])serializerFeatures);
    }

    public static String toJson(Object value, final Map<Class<?>, List<String>> classOfProps) {
        return JSON.toJSONString((Object)value, (SerializeFilter)new PropertyFilter(){

            public boolean apply(Object object, String name, Object value) {
                List props = (List)classOfProps.get(object.getClass());
                return !props.contains(name);
            }
        }, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.BrowserCompatible});
    }

    public static String toJson(Object value, SerializerFeature ... features) {
        Assert.notNull(features, "Array SerializerFeature is null or empty.");
        return JSON.toJSONString((Object)value, (SerializerFeature[])features);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return (T)JSON.parseObject((String)json, clazz);
    }

    public static <T> T fromJson(String json, TypeRef<T> typeRef) {
        return (T)JSON.parseObject((String)json, (Type)typeRef.getType(), (Feature[])new Feature[0]);
    }

    public static void println(Object value) {
        System.out.println(JsonUtil.toJson(value, SerializerFeature.PrettyFormat, SerializerFeature.BrowserCompatible));
    }
}

