/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.json.gson;

import java.io.StringWriter;

class UnicodeStringWriter
extends StringWriter {
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();
    private static final int[] ESCAPE_CODES;

    UnicodeStringWriter() {
    }

    @Override
    public String toString() {
        String src = super.toString();
        StringBuffer builder = new StringBuffer(src.length() * 4);
        for (char c : src.toCharArray()) {
            int code;
            if (c >= '\u0080') {
                this.writeUnicodeEscape(builder, c);
                continue;
            }
            int n = code = c < ESCAPE_CODES.length ? ESCAPE_CODES[c] : 0;
            if (code == 0) {
                builder.append(c);
                continue;
            }
            if (code < 0) {
                this.writeUnicodeEscape(builder, (char)(-code - 1));
                continue;
            }
            builder.append("\\").append((char)code);
        }
        return builder.toString();
    }

    private void writeUnicodeEscape(StringBuffer builder, char c) {
        builder.append("\\u");
        builder.append(HEX_CHARS[c >> 12 & 0xF]);
        builder.append(HEX_CHARS[c >> 8 & 0xF]);
        builder.append(HEX_CHARS[c >> 4 & 0xF]);
        builder.append(HEX_CHARS[c & 0xF]);
    }

    static {
        int[] table = new int[128];
        for (int i = 0; i < 32; ++i) {
            table[i] = -1;
        }
        table[47] = 47;
        ESCAPE_CODES = table;
    }
}

