/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.lang;

public class CharsetUtils {
    public static String gbk2utf8(String gbkStr) {
        String temp = CharsetUtils.gbk2Unicode(gbkStr);
        return CharsetUtils.unicodeToUtf8(temp);
    }

    public static String utf82gbk(String utf8Str) {
        String temp = CharsetUtils.utf8ToUnicode(utf8Str);
        return CharsetUtils.unicode2GBK(temp);
    }

    public static String gbk2Unicode(String gbkStr) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < gbkStr.length(); ++i) {
            char chr1 = gbkStr.charAt(i);
            if (!CharsetUtils.isNeedConvert(chr1)) {
                result.append(chr1);
                continue;
            }
            result.append("\\u").append(Integer.toHexString(chr1));
        }
        return result.toString();
    }

    public static String unicode2GBK(String unicodeStr) {
        int index = 0;
        StringBuilder buffer = new StringBuilder();
        int li_len = unicodeStr.length();
        while (index < li_len) {
            if (index >= li_len - 1 || !"\\u".equals(unicodeStr.substring(index, index + 2))) {
                buffer.append(unicodeStr.charAt(index));
                ++index;
                continue;
            }
            String charStr = unicodeStr.substring(index + 2, index + 6);
            char letter = (char)Integer.parseInt(charStr, 16);
            buffer.append(letter);
            index += 6;
        }
        return buffer.toString();
    }

    private static boolean isNeedConvert(char para) {
        return (para & 0xFF) != para;
    }

    public static String utf8ToUnicode(String utf8Str) {
        char[] myBuffer = utf8Str.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < utf8Str.length(); ++i) {
            Character.UnicodeBlock ub = Character.UnicodeBlock.of(myBuffer[i]);
            if (ub == Character.UnicodeBlock.BASIC_LATIN) {
                sb.append(myBuffer[i]);
                continue;
            }
            if (ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
                int j = myBuffer[i] - 65248;
                sb.append((char)j);
                continue;
            }
            short s = (short)myBuffer[i];
            String hexS = Integer.toHexString(s);
            String unicode = "\\u" + hexS;
            sb.append(unicode.toLowerCase());
        }
        return sb.toString();
    }

    public static String unicodeToUtf8(String theString) {
        int len = theString.length();
        StringBuilder outBuffer = new StringBuilder(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }
}

