/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.utils;

import com.mzlion.core.beans.PropertyUtilBean;
import com.mzlion.core.exceptions.FatalBeanException;
import com.mzlion.core.lang.Assert;
import com.mzlion.core.utils.ClassUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanUtils {
    public static Map<String, Object> toMapAsValueObject(Object bean) {
        Assert.notNull(bean, "No bean specified");
        List<PropertyDescriptor> propertyDescriptors = PropertyUtilBean.getInstance().getPropertyDescriptors(bean);
        try {
            HashMap<String, Object> propertiesMap = new HashMap<String, Object>(propertyDescriptors.size());
            for (PropertyDescriptor pd : propertyDescriptors) {
                Method readMethod = pd.getReadMethod();
                propertiesMap.put(pd.getName(), readMethod.invoke(bean, new Object[0]));
            }
            return propertiesMap;
        }
        catch (Exception e) {
            throw new FatalBeanException("Cannot read property value", e);
        }
    }

    public static Map<String, String> toMapAsValueString(Object bean) {
        return BeanUtils.toMapAsValueString(bean, true);
    }

    public static Map<String, String> toMapAsValueString(Object bean, boolean ignoreNull) {
        Map<String, Object> propertiesMap = BeanUtils.toMapAsValueObject(bean);
        HashMap<String, String> resultMap = new HashMap<String, String>(propertiesMap.size());
        for (String propertyName : propertiesMap.keySet()) {
            Object _value = propertiesMap.get(propertyName);
            if (_value == null) {
                if (ignoreNull) continue;
                resultMap.put(propertyName, null);
                continue;
            }
            if (_value instanceof Number) {
                Number number = (Number)_value;
                resultMap.put(propertyName, number.toString());
                continue;
            }
            if (_value instanceof String) {
                resultMap.put(propertyName, (String)_value);
                continue;
            }
            if (_value instanceof Date) {
                resultMap.put(propertyName, String.valueOf(((Date)_value).getTime()));
                continue;
            }
            resultMap.put(propertyName, _value.toString());
        }
        return resultMap;
    }

    public static void copyProperties(Object source, Object target) {
        BeanUtils.copyProperties(source, target, new String[]{null});
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) {
        Assert.notNull(source, "Source must not be null");
        Assert.notNull(target, "Target must not be null");
        List<PropertyDescriptor> targetPDList = PropertyUtilBean.getInstance().getPropertyDescriptors(target);
        List<String> ignoreList = ignoreProperties == null ? null : Arrays.asList(ignoreProperties);
        for (PropertyDescriptor targetPD : targetPDList) {
            Method readMethod;
            PropertyDescriptor sourcePD;
            Method writeMethod = targetPD.getWriteMethod();
            if (writeMethod == null || ignoreList != null && ignoreList.contains(targetPD.getName()) || (sourcePD = PropertyUtilBean.getInstance().getPropertyDescriptor(source, targetPD.getName())) == null || (readMethod = sourcePD.getReadMethod()) == null || !ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
            if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                readMethod.setAccessible(true);
            }
            try {
                Object value = readMethod.invoke(source, new Object[0]);
                if (Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new FatalBeanException(String.format("Could not copy property '%s' from source to target", targetPD.getName()), e);
            }
        }
    }
}

