/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.apollo.configuration;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.nepxion.discovery.common.apollo.operation.ApolloOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class ApolloAutoConfiguration {
    @Autowired
    private Environment environment;

    @Bean
    @ConditionalOnMissingBean
    public Config apolloConfig() {
        String namespace = ApolloAutoConfiguration.getNamespace(this.environment);
        return ConfigService.getConfig((String)namespace);
    }

    @Bean
    public ApolloOperation apolloOperation() {
        return new ApolloOperation();
    }

    public static String getNamespace(Environment environment) {
        String namespace = environment.getProperty("apollo.plugin.namespace");
        if (StringUtils.isEmpty((CharSequence)namespace) || namespace.contains(",")) {
            namespace = environment.getProperty("apollo.bootstrap.namespaces");
        }
        if (StringUtils.isEmpty((CharSequence)namespace) || namespace.contains(",")) {
            namespace = "application";
        }
        return namespace;
    }
}

