/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.apollo.operation;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.google.common.collect.Sets;
import com.nepxion.discovery.common.apollo.operation.ApolloSubscribeCallback;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class ApolloOperation {
    @Autowired
    private Config apolloConfig;

    public String getConfig(String group, String serviceId) {
        return this.apolloConfig.getProperty(group + "-" + serviceId, null);
    }

    public ConfigChangeListener subscribeConfig(final String group, final String serviceId, final ApolloSubscribeCallback subscribeCallback) {
        ConfigChangeListener configListener = new ConfigChangeListener(){

            public void onChange(ConfigChangeEvent changeEvent) {
                ConfigChange change = changeEvent.getChange(group + "-" + serviceId);
                String config = change.getNewValue();
                subscribeCallback.callback(config);
            }
        };
        this.apolloConfig.addChangeListener(configListener, (Set)Sets.newHashSet((Object[])new String[]{group + "-" + serviceId}));
        return configListener;
    }

    public void unsubscribeConfig(String group, String serviceId, ConfigChangeListener configListener) {
        this.apolloConfig.removeChangeListener(configListener);
    }
}

