/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.console.apollo.adapter;

import com.ctrip.framework.apollo.openapi.client.ApolloOpenApiClient;
import com.ctrip.framework.apollo.openapi.dto.NamespaceReleaseDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenItemDTO;
import com.nepxion.discovery.console.adapter.ConfigAdapter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class ApolloConfigAdapter
implements ConfigAdapter {
    @Autowired
    private Environment environment;
    @Autowired
    private ApolloOpenApiClient apolloOpenApiClient;

    public boolean updateConfig(String group, String serviceId, String config) throws Exception {
        String appId = this.environment.getProperty("apollo.plugin.app.id");
        if (StringUtils.isEmpty((CharSequence)appId)) {
            throw new IllegalArgumentException("apollo.plugin.app.id can't be null or empty");
        }
        String env = this.environment.getProperty("apollo.plugin.env");
        if (StringUtils.isEmpty((CharSequence)env)) {
            throw new IllegalArgumentException("apollo.plugin.env can't be null or empty");
        }
        String operator = this.environment.getProperty("apollo.operator");
        if (StringUtils.isEmpty((CharSequence)operator)) {
            throw new IllegalArgumentException("apollo.operator can't be null or empty");
        }
        String cluster = (String)this.environment.getProperty("apollo.plugin.cluster", String.class, (Object)"default");
        String namespace = (String)this.environment.getProperty("apollo.plugin.namespace", String.class, (Object)"application");
        Date now = new Date();
        OpenItemDTO openItemDTO = new OpenItemDTO();
        openItemDTO.setKey(group + "-" + serviceId);
        openItemDTO.setValue(config);
        openItemDTO.setComment("Operated by Nepxion Discovery Console");
        openItemDTO.setDataChangeCreatedBy(operator);
        openItemDTO.setDataChangeLastModifiedBy(operator);
        openItemDTO.setDataChangeCreatedTime(now);
        openItemDTO.setDataChangeLastModifiedTime(now);
        this.apolloOpenApiClient.createOrUpdateItem(appId, env, cluster, namespace, openItemDTO);
        NamespaceReleaseDTO namespaceReleaseDTO = new NamespaceReleaseDTO();
        namespaceReleaseDTO.setReleaseTitle(new SimpleDateFormat("yyyyMMddHHmmss").format(now) + "-release");
        namespaceReleaseDTO.setReleasedBy(operator);
        namespaceReleaseDTO.setReleaseComment("Released by Nepxion Discovery Console");
        namespaceReleaseDTO.setEmergencyPublish(true);
        this.apolloOpenApiClient.publishNamespace(appId, env, cluster, namespace, namespaceReleaseDTO);
        return true;
    }

    public boolean clearConfig(String group, String serviceId) throws Exception {
        String appId = this.environment.getProperty("apollo.plugin.app.id");
        if (StringUtils.isEmpty((CharSequence)appId)) {
            throw new IllegalArgumentException("apollo.plugin.app.id can't be null or empty");
        }
        String env = this.environment.getProperty("apollo.plugin.env");
        if (StringUtils.isEmpty((CharSequence)env)) {
            throw new IllegalArgumentException("apollo.plugin.env can't be null or empty");
        }
        String operator = this.environment.getProperty("apollo.operator");
        if (StringUtils.isEmpty((CharSequence)operator)) {
            throw new IllegalArgumentException("apollo.operator can't be null or empty");
        }
        String cluster = (String)this.environment.getProperty("apollo.plugin.cluster", String.class, (Object)"default");
        String namespace = (String)this.environment.getProperty("apollo.plugin.namespace", String.class, (Object)"application");
        this.apolloOpenApiClient.removeItem(appId, env, cluster, namespace, group + "-" + serviceId, operator);
        Date now = new Date();
        NamespaceReleaseDTO namespaceReleaseDTO = new NamespaceReleaseDTO();
        namespaceReleaseDTO.setReleaseTitle(new SimpleDateFormat("yyyyMMddHHmmss").format(now) + "-release");
        namespaceReleaseDTO.setReleasedBy(operator);
        namespaceReleaseDTO.setReleaseComment("Deleted by Nepxion Discovery Console");
        namespaceReleaseDTO.setEmergencyPublish(true);
        this.apolloOpenApiClient.publishNamespace(appId, env, cluster, namespace, namespaceReleaseDTO);
        return true;
    }

    public String getConfig(String group, String serviceId) throws Exception {
        String appId = this.environment.getProperty("apollo.plugin.app.id");
        if (StringUtils.isEmpty((CharSequence)appId)) {
            throw new IllegalArgumentException("apollo.plugin.app.id can't be null or empty");
        }
        String env = this.environment.getProperty("apollo.plugin.env");
        if (StringUtils.isEmpty((CharSequence)env)) {
            throw new IllegalArgumentException("apollo.plugin.env can't be null or empty");
        }
        String cluster = (String)this.environment.getProperty("apollo.plugin.cluster", String.class, (Object)"default");
        String namespace = (String)this.environment.getProperty("apollo.plugin.namespace", String.class, (Object)"application");
        return (String)this.apolloOpenApiClient.getLatestActiveRelease(appId, env, cluster, namespace).getConfigurations().get(group + "-" + serviceId);
    }

    public String getConfigType() {
        return "Apollo";
    }
}

