/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.console.apollo.configuration;

import com.ctrip.framework.apollo.openapi.client.ApolloOpenApiClient;
import com.nepxion.banner.Description;
import com.nepxion.banner.LogoBanner;
import com.nepxion.banner.NepxionBanner;
import com.nepxion.discovery.console.adapter.ConfigAdapter;
import com.nepxion.discovery.console.apollo.adapter.ApolloConfigAdapter;
import com.taobao.text.Color;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class ApolloConfigAutoConfiguration {
    @Autowired
    private Environment environment;

    @Bean
    public ApolloOpenApiClient openApiClient() {
        String portalUrl = this.environment.getProperty("apollo.portal-url");
        if (StringUtils.isEmpty((CharSequence)portalUrl)) {
            throw new IllegalArgumentException("apollo.portal-url can't be null or empty");
        }
        String token = this.environment.getProperty("apollo.token");
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new IllegalArgumentException("apollo.token can't be null or empty");
        }
        int connectTimeout = (Integer)this.environment.getProperty("apollo.connect-timeout", Integer.class, (Object)1000);
        int readTimeout = (Integer)this.environment.getProperty("apollo.read-timeout", Integer.class, (Object)5000);
        return ApolloOpenApiClient.newBuilder().withPortalUrl(portalUrl).withToken(token).withConnectTimeout(connectTimeout).withReadTimeout(readTimeout).build();
    }

    @Bean
    public ConfigAdapter configAdapter() {
        return new ApolloConfigAdapter();
    }

    static {
        LogoBanner logoBanner = new LogoBanner(ApolloConfigAutoConfiguration.class, "/com/nepxion/apollo/resource/logo.txt", "Welcome to Nepxion", 6, 5, new Color[]{Color.red, Color.green, Color.cyan, Color.blue, Color.yellow, Color.magenta}, true);
        NepxionBanner.show((LogoBanner)logoBanner, (Description[])new Description[]{new Description("Config:", "Apollo", 0, 1), new Description("Github:", "https://github.com/Nepxion/Discovery", 0, 1)});
    }
}

