/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.sentinel.loader;

import com.alibaba.csp.sentinel.datasource.ReadableDataSource;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.strategy.sentinel.loader.SentinelFileRuleLoader;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SentinelDataSourceRuleLoader
extends SentinelFileRuleLoader {
    private static final Logger LOG = LoggerFactory.getLogger(SentinelDataSourceRuleLoader.class);
    @Autowired
    protected PluginAdapter pluginAdapter;

    @Override
    public void load() {
        this.initialize();
        String groupKey = this.pluginAdapter.getGroupKey();
        String group = this.pluginAdapter.getGroup();
        String serviceId = this.pluginAdapter.getServiceId();
        LOG.info("Subscribe flow rules from {} server, {}={}, serviceId={}", new Object[]{this.getConfigType(), groupKey, group, serviceId + "-" + "sentinel-flow"});
        ReadableDataSource<String, List<FlowRule>> flowRuleDataSource = this.getFlowRuleDataSource();
        FlowRuleManager.register2Property((SentinelProperty)flowRuleDataSource.getProperty());
        LOG.info("{} flow rules form datasource loaded...", (Object)FlowRuleManager.getRules().size());
        LOG.info("Subscribe degrade rules from {} server, {}={}, serviceId={}", new Object[]{this.getConfigType(), groupKey, group, serviceId + "-" + "sentinel-degrade"});
        ReadableDataSource<String, List<DegradeRule>> degradeRuleDataSource = this.getDegradeRuleDataSource();
        DegradeRuleManager.register2Property((SentinelProperty)degradeRuleDataSource.getProperty());
        LOG.info("{} degrade rules form datasource loaded...", (Object)DegradeRuleManager.getRules().size());
        LOG.info("Subscribe authority rules from {} server, {}={}, serviceId={}", new Object[]{this.getConfigType(), groupKey, group, serviceId + "-" + "sentinel-authority"});
        ReadableDataSource<String, List<AuthorityRule>> authorityRuleDataSource = this.getAuthorityRuleDataSource();
        AuthorityRuleManager.register2Property((SentinelProperty)authorityRuleDataSource.getProperty());
        LOG.info("{} authority rules form datasource loaded...", (Object)AuthorityRuleManager.getRules().size());
        LOG.info("Subscribe system rules from {} server, {}={}, serviceId={}", new Object[]{this.getConfigType(), groupKey, group, serviceId + "-" + "sentinel-system"});
        ReadableDataSource<String, List<SystemRule>> systemRuleDataSource = this.getSystemRuleDataSource();
        SystemRuleManager.register2Property((SentinelProperty)systemRuleDataSource.getProperty());
        LOG.info("{} system rules form datasource loaded...", (Object)SystemRuleManager.getRules().size());
        LOG.info("Subscribe param flow rules from {} server, {}={}, serviceId={}", new Object[]{this.getConfigType(), groupKey, group, serviceId + "-" + "sentinel-param-flow"});
        ReadableDataSource<String, List<ParamFlowRule>> paramFlowRuleDataSource = this.getParamFlowRuleDataSource();
        ParamFlowRuleManager.register2Property((SentinelProperty)paramFlowRuleDataSource.getProperty());
        LOG.info("{} param flow rules form datasource loaded...", (Object)ParamFlowRuleManager.getRules().size());
        super.load();
    }

    public PluginAdapter getPluginAdapter() {
        return this.pluginAdapter;
    }

    public abstract void initialize();

    public abstract ReadableDataSource<String, List<FlowRule>> getFlowRuleDataSource();

    public abstract ReadableDataSource<String, List<DegradeRule>> getDegradeRuleDataSource();

    public abstract ReadableDataSource<String, List<AuthorityRule>> getAuthorityRuleDataSource();

    public abstract ReadableDataSource<String, List<SystemRule>> getSystemRuleDataSource();

    public abstract ReadableDataSource<String, List<ParamFlowRule>> getParamFlowRuleDataSource();

    public abstract String getConfigType();
}

