/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.sentinel.loader;

import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import com.nepxion.discovery.plugin.framework.util.FileContextUtil;
import com.nepxion.discovery.plugin.strategy.sentinel.loader.SentinelRuleLoader;
import com.nepxion.discovery.plugin.strategy.sentinel.parser.SentinelAuthorityRuleParser;
import com.nepxion.discovery.plugin.strategy.sentinel.parser.SentinelDegradeRuleParser;
import com.nepxion.discovery.plugin.strategy.sentinel.parser.SentinelFlowRuleParser;
import com.nepxion.discovery.plugin.strategy.sentinel.parser.SentinelParamFlowRuleParser;
import com.nepxion.discovery.plugin.strategy.sentinel.parser.SentinelSystemRuleParser;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;

public class SentinelFileRuleLoader
implements SentinelRuleLoader {
    private static final Logger LOG = LoggerFactory.getLogger(SentinelFileRuleLoader.class);
    @Value(value="${spring.application.strategy.sentinel.flow.path:classpath:sentinel-flow.json}")
    protected String flowPath;
    @Value(value="${spring.application.strategy.sentinel.degrade.path:classpath:sentinel-degrade.json}")
    protected String degradePath;
    @Value(value="${spring.application.strategy.sentinel.authority.path:classpath:sentinel-authority.json}")
    protected String authorityPath;
    @Value(value="${spring.application.strategy.sentinel.system.path:classpath:sentinel-system.json}")
    protected String systemPath;
    @Value(value="${spring.application.strategy.sentinel.param.flow.path:classpath:sentinel-param-flow.json}")
    protected String paramFlowPath;
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected SentinelFlowRuleParser sentinelFlowRuleParser;
    @Autowired
    protected SentinelDegradeRuleParser sentinelDegradeRuleParser;
    @Autowired
    protected SentinelAuthorityRuleParser sentinelAuthorityRuleParser;
    @Autowired
    protected SentinelSystemRuleParser sentinelSystemRuleParser;
    @Autowired
    protected SentinelParamFlowRuleParser sentinelParamFlowRuleParser;

    @Override
    public void load() {
        if (CollectionUtils.isEmpty((Collection)FlowRuleManager.getRules())) {
            FlowRuleManager.loadRules(this.sentinelFlowRuleParser.convert(this.getSentinelRule(this.flowPath)));
            LOG.info("{} flow rules form file loaded...", (Object)FlowRuleManager.getRules().size());
        } else {
            LOG.info("{} flow rules exists, ignore to load from file...", (Object)FlowRuleManager.getRules().size());
        }
        if (CollectionUtils.isEmpty((Collection)DegradeRuleManager.getRules())) {
            DegradeRuleManager.loadRules(this.sentinelDegradeRuleParser.convert(this.getSentinelRule(this.degradePath)));
            LOG.info("{} degrade rules form file loaded...", (Object)DegradeRuleManager.getRules().size());
        } else {
            LOG.info("{} degrade rules exists, ignore to load from file...", (Object)DegradeRuleManager.getRules().size());
        }
        if (CollectionUtils.isEmpty((Collection)AuthorityRuleManager.getRules())) {
            AuthorityRuleManager.loadRules(this.sentinelAuthorityRuleParser.convert(this.getSentinelRule(this.authorityPath)));
            LOG.info("{} authority rules form file loaded...", (Object)AuthorityRuleManager.getRules().size());
        } else {
            LOG.info("{} authority rules exists, ignore to load from file...", (Object)AuthorityRuleManager.getRules().size());
        }
        if (CollectionUtils.isEmpty((Collection)SystemRuleManager.getRules())) {
            SystemRuleManager.loadRules(this.sentinelSystemRuleParser.convert(this.getSentinelRule(this.systemPath)));
            LOG.info("{} system rules form file loaded...", (Object)SystemRuleManager.getRules().size());
        } else {
            LOG.info("{} system rules exists, ignore to load from file...", (Object)SystemRuleManager.getRules().size());
        }
        if (CollectionUtils.isEmpty((Collection)ParamFlowRuleManager.getRules())) {
            ParamFlowRuleManager.loadRules(this.sentinelParamFlowRuleParser.convert(this.getSentinelRule(this.paramFlowPath)));
            LOG.info("{} param flow rules form file loaded...", (Object)ParamFlowRuleManager.getRules().size());
        } else {
            LOG.info("{} param flow rules exists, ignore to load from file...", (Object)ParamFlowRuleManager.getRules().size());
        }
    }

    public String getFlowPath() {
        return this.flowPath;
    }

    public String getDegradePath() {
        return this.degradePath;
    }

    public String getAuthorityPath() {
        return this.authorityPath;
    }

    public String getSystemPath() {
        return this.systemPath;
    }

    public String getParamFlowPath() {
        return this.paramFlowPath;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public SentinelFlowRuleParser getSentinelFlowRuleParser() {
        return this.sentinelFlowRuleParser;
    }

    public SentinelDegradeRuleParser getSentinelDegradeRuleParser() {
        return this.sentinelDegradeRuleParser;
    }

    public SentinelAuthorityRuleParser getSentinelAuthorityRuleParser() {
        return this.sentinelAuthorityRuleParser;
    }

    public SentinelSystemRuleParser getSentinelSystemRuleParser() {
        return this.sentinelSystemRuleParser;
    }

    public SentinelParamFlowRuleParser getSentinelParamFlowRuleParser() {
        return this.sentinelParamFlowRuleParser;
    }

    public String getSentinelRule(String path) {
        String rule = FileContextUtil.getText((ApplicationContext)this.applicationContext, (String)path);
        return StringUtils.isNotEmpty((CharSequence)rule) ? rule : "[]";
    }
}

