/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.condition;

import com.nepxion.discovery.common.entity.StrategyConditionEntity;
import com.nepxion.discovery.common.expression.DiscoveryExpressionResolver;
import com.nepxion.discovery.plugin.strategy.condition.AbstractStrategyCondition;
import com.nepxion.discovery.plugin.strategy.wrapper.StrategyWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.TypeComparator;

public class HeaderExpressionStrategyCondition
extends AbstractStrategyCondition {
    private Pattern pattern = Pattern.compile("\\#H\\['\\S+'\\]");
    @Autowired
    private StrategyWrapper strategyWrapper;

    @Override
    public boolean isTriggered(StrategyConditionEntity strategyConditionEntity) {
        Map<String, String> headerMap = this.createHeaderMap(strategyConditionEntity);
        return this.isTriggered(strategyConditionEntity, headerMap);
    }

    private Map<String, String> createHeaderMap(StrategyConditionEntity strategyConditionEntity) {
        String conditionHeader = strategyConditionEntity.getConditionHeader();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Matcher matcher = this.pattern.matcher(conditionHeader);
        while (matcher.find()) {
            String group = matcher.group();
            String headerName = StringUtils.substringBetween((String)group, (String)"#H['", (String)"']");
            String headerValue = null;
            if (StringUtils.isBlank(headerValue)) {
                headerValue = this.strategyContextHolder.getHeader(headerName);
            }
            if (StringUtils.isBlank(headerValue)) {
                headerValue = this.strategyWrapper.getHeader(headerName);
            }
            if (StringUtils.isBlank((CharSequence)headerValue)) {
                headerValue = this.strategyContextHolder.getParameter(headerName);
            }
            if (StringUtils.isBlank((CharSequence)headerValue)) {
                headerValue = this.strategyContextHolder.getCookie(headerName);
            }
            if (!StringUtils.isNotBlank((CharSequence)headerValue)) continue;
            headerMap.put(headerName, headerValue);
        }
        return headerMap;
    }

    @Override
    public boolean isTriggered(StrategyConditionEntity strategyConditionEntity, Map<String, String> headerMap) {
        String conditionHeader = strategyConditionEntity.getConditionHeader();
        return DiscoveryExpressionResolver.eval((String)conditionHeader, (String)"H", headerMap, (TypeComparator)this.strategyTypeComparator);
    }
}

