/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.test.automation.aop;

import com.nepxion.discovery.plugin.test.automation.annotation.DTest;
import com.nepxion.discovery.plugin.test.automation.annotation.DTestConfig;
import com.nepxion.discovery.plugin.test.automation.operation.TestOperation;
import com.nepxion.matrix.proxy.aop.AbstractInterceptor;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class TestInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(TestInterceptor.class);
    @Autowired
    private TestOperation testOperation;
    @Value(value="${spring.application.test.config.operation.await.time:3000}")
    private Integer configOperationAwaitTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        boolean isTestAnnotationPresent = method.isAnnotationPresent(DTest.class);
        boolean isTestConfigAnnotationPresent = method.isAnnotationPresent(DTestConfig.class);
        if (isTestAnnotationPresent || isTestConfigAnnotationPresent) {
            String methodName = this.getMethodName(invocation);
            LOG.info("---------- Run automation testcase :: {}() ----------", (Object)methodName);
            Object object = null;
            if (isTestAnnotationPresent) {
                object = invocation.proceed();
            } else {
                DTestConfig testConfigAnnotation = method.getAnnotation(DTestConfig.class);
                String group = this.convertSpel(invocation, testConfigAnnotation.group());
                String serviceId = this.convertSpel(invocation, testConfigAnnotation.serviceId());
                String prefix = this.convertSpel(invocation, testConfigAnnotation.prefix());
                String suffix = this.convertSpel(invocation, testConfigAnnotation.suffix());
                String executePath = this.convertSpel(invocation, testConfigAnnotation.executePath());
                String resetPath = this.convertSpel(invocation, testConfigAnnotation.resetPath());
                if (StringUtils.isNotEmpty((CharSequence)prefix)) {
                    group = prefix + "-" + group;
                }
                if (StringUtils.isNotEmpty((CharSequence)suffix)) {
                    serviceId = serviceId + "-" + suffix;
                }
                this.testOperation.update(group, serviceId, executePath);
                Thread.sleep(this.configOperationAwaitTime.intValue());
                try {
                    object = invocation.proceed();
                }
                finally {
                    if (StringUtils.isNotEmpty((CharSequence)resetPath)) {
                        this.testOperation.update(group, serviceId, resetPath);
                    } else {
                        this.testOperation.clear(group, serviceId);
                    }
                    Thread.sleep(this.configOperationAwaitTime.intValue());
                }
            }
            LOG.info("* Passed");
            return object;
        }
        return invocation.proceed();
    }

    private String convertSpel(MethodInvocation invocation, String key) {
        String spelKey = null;
        try {
            spelKey = this.getSpelKey(invocation, key);
        }
        catch (Exception e) {
            spelKey = key;
        }
        return spelKey;
    }
}

