/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.test.automation.configuration;

import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.plugin.test.automation.aop.TestAutoScanProxy;
import com.nepxion.discovery.plugin.test.automation.aop.TestInterceptor;
import com.nepxion.discovery.plugin.test.automation.operation.TestOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
public class TestAutoConfiguration {
    @Autowired
    private ConfigurableEnvironment environment;

    @Bean
    public TestAutoScanProxy testAutoScanProxy() {
        String scanPackages = this.environment.getProperty("spring.application.test.scan.packages");
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            throw new DiscoveryException("spring.application.test.scan.packages's value can't be empty");
        }
        return new TestAutoScanProxy(scanPackages);
    }

    @Bean
    public TestInterceptor testInterceptor() {
        String scanPackages = this.environment.getProperty("spring.application.test.scan.packages");
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            throw new DiscoveryException("spring.application.test.scan.packages's value can't be empty");
        }
        return new TestInterceptor();
    }

    @Bean
    public TestOperation testOperation() {
        return new TestOperation();
    }
}

