/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.test.automation.operation;

import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.common.property.DiscoveryContent;
import com.nepxion.discovery.common.util.UrlUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.web.client.TestRestTemplate;

public class TestOperation {
    private static final Logger LOG = LoggerFactory.getLogger(TestOperation.class);
    @Value(value="${spring.application.test.console.url}")
    private String consoleUrl;
    @Value(value="${spring.application.test.config.print.enabled:true}")
    private Boolean configPrintEnabled;
    @Autowired
    private TestRestTemplate testRestTemplate;

    public String update(String group, String serviceId, String path) {
        String content = null;
        try {
            DiscoveryContent discoveryContent = new DiscoveryContent(path, "UTF-8");
            content = discoveryContent.getContent();
        }
        catch (IOException e) {
            throw new DiscoveryException((Throwable)e);
        }
        if (this.configPrintEnabled.booleanValue()) {
            LOG.info("Update config, group={}, serviceId={}, path={}, content=\n{}", new Object[]{group, serviceId, path, content});
        }
        String url = this.consoleUrl + UrlUtil.formatContextPath((String)"console/remote-config/update") + group + "/" + serviceId;
        return (String)this.testRestTemplate.postForEntity(url, (Object)content, String.class, new Object[0]).getBody();
    }

    public String clear(String group, String serviceId) {
        if (this.configPrintEnabled.booleanValue()) {
            LOG.info("Clear config, group={}, serviceId={}", (Object)group, (Object)serviceId);
        }
        String url = this.consoleUrl + UrlUtil.formatContextPath((String)"console/remote-config/clear") + group + "/" + serviceId;
        return (String)this.testRestTemplate.postForEntity(url, null, String.class, new Object[0]).getBody();
    }
}

