/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.eventbus.thread.policy;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingPolicyWithReport
implements RejectedExecutionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingPolicyWithReport.class);
    private String threadName;

    public BlockingPolicyWithReport() {
        this(null);
    }

    public BlockingPolicyWithReport(String threadName) {
        this.threadName = threadName;
    }

    @Override
    public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
        if (this.threadName != null) {
            LOG.error("Thread pool [{}] is exhausted, executor={}", (Object)this.threadName, (Object)executor.toString());
        }
        if (!executor.isShutdown()) {
            try {
                executor.getQueue().put(runnable);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

