/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.atlas.AtlasMeter;
import com.netflix.spectator.atlas.DsType;
import com.netflix.spectator.impl.StepDouble;
import java.util.Collections;

class AtlasCounter
extends AtlasMeter
implements Counter {
    private final StepDouble value;
    private final Id stat;

    AtlasCounter(Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.value = new StepDouble(0.0, clock, step);
        this.stat = id.withTag((Tag)Statistic.count).withTags(id.tags()).withTag((Tag)DsType.rate);
    }

    public Iterable<Measurement> measure() {
        double rate = this.value.pollAsRate();
        Measurement m = new Measurement(this.stat, this.value.timestamp(), rate);
        return Collections.singletonList(m);
    }

    public void add(double amount) {
        if (Double.isFinite(amount) && amount > 0.0) {
            this.value.getCurrent().addAndGet(amount);
            this.updateLastModTime();
        }
    }

    public double actualCount() {
        return this.value.poll();
    }
}

