/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.http;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.ContentTypeUtils;
import javax.mail.internet.ContentType;

abstract class HTTPMessage {
    private ContentType contentType = null;

    HTTPMessage() {
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType ct) {
        this.contentType = ct;
    }

    public void setContentType(String ct) throws ParseException {
        if (ct == null) {
            this.contentType = null;
            return;
        }
        try {
            this.contentType = new ContentType(ct);
        }
        catch (javax.mail.internet.ParseException e) {
            throw new ParseException("Invalid Content-Type value: " + e.getMessage());
        }
    }

    public void ensureContentType() throws ParseException {
        if (this.contentType == null) {
            throw new ParseException("Missing HTTP Content-Type header");
        }
    }

    public void ensureContentType(ContentType contentType) throws ParseException {
        ContentTypeUtils.ensureContentType(contentType, this.getContentType());
    }
}

