/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.hbase;

import com.alipay.oceanbase.hbase.OHTable;
import com.alipay.oceanbase.hbase.core.Lifecycle;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.util.Pair;

public class OHTableClient
implements HTableInterface,
Lifecycle {
    private byte[] tableName;
    private String tableNameString;
    private ReentrantLock lock = new ReentrantLock();
    private OHTable ohTable;
    private volatile boolean initialized = false;
    private final Configuration conf;
    private ExecutorService runtimeBatchExecutor;

    public void setRuntimeBatchExecutor(ExecutorService runtimeBatchExecutor) {
        this.runtimeBatchExecutor = runtimeBatchExecutor;
    }

    public OHTableClient(String tableNameString, Configuration conf) {
        this.tableNameString = tableNameString;
        this.tableName = tableNameString.getBytes();
        this.conf = conf;
    }

    @Override
    public void init() throws Exception {
        if (!this.initialized) {
            this.lock.lock();
            try {
                if (!this.initialized) {
                    this.ohTable = new OHTable(this.conf, this.tableNameString);
                    this.initialized = true;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.initialized) {
            this.lock.lock();
            try {
                if (this.initialized && this.ohTable != null) {
                    this.ohTable.close();
                }
            }
            finally {
                this.initialized = false;
                this.lock.unlock();
            }
        }
    }

    private void checkStatus() throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("tableName " + this.tableNameString + " is not initialized");
        }
    }

    public RowLock lockRow(byte[] row) throws IOException {
        this.checkStatus();
        return this.ohTable.lockRow(row);
    }

    public void unlockRow(RowLock rl) throws IOException {
        this.checkStatus();
        this.ohTable.unlockRow(rl);
    }

    public <T extends CoprocessorProtocol> T coprocessorProxy(Class<T> protocol, byte[] row) {
        this.checkStatus();
        return this.ohTable.coprocessorProxy(protocol, row);
    }

    public <T extends CoprocessorProtocol, R> Map<byte[], R> coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws IOException, Throwable {
        this.checkStatus();
        return this.ohTable.coprocessorExec(protocol, startKey, endKey, callable);
    }

    public <T extends CoprocessorProtocol, R> void coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws IOException, Throwable {
        this.checkStatus();
        this.ohTable.coprocessorExec(protocol, startKey, endKey, callable, callback);
    }

    public void setAutoFlush(boolean autoFlush) {
        this.checkStatus();
        this.ohTable.setAutoFlush(autoFlush);
    }

    public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
        this.checkStatus();
        this.ohTable.setAutoFlush(autoFlush, clearBufferOnFail);
    }

    public long getWriteBufferSize() {
        this.checkStatus();
        return this.ohTable.getWriteBufferSize();
    }

    public void setWriteBufferSize(long writeBufferSize) throws IOException {
        this.checkStatus();
        this.ohTable.setWriteBufferSize(writeBufferSize);
    }

    public byte[] getTableName() {
        return this.tableName;
    }

    public Configuration getConfiguration() {
        this.checkStatus();
        return this.ohTable.getConfiguration();
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        this.checkStatus();
        return this.ohTable.getTableDescriptor();
    }

    public boolean exists(Get get) throws IOException {
        this.checkStatus();
        return this.ohTable.exists(get);
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
        this.checkStatus();
        this.ohTable.batch(actions, results);
    }

    public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
        this.checkStatus();
        return this.ohTable.batch(actions);
    }

    public Result get(Get get) throws IOException {
        this.checkStatus();
        return this.ohTable.get(get);
    }

    public Result[] get(List<Get> gets) throws IOException {
        this.checkStatus();
        return this.ohTable.get(gets);
    }

    public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
        this.checkStatus();
        return this.ohTable.getRowOrBefore(row, family);
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        this.checkStatus();
        return this.ohTable.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        this.checkStatus();
        return this.ohTable.getScanner(family);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        this.checkStatus();
        return this.ohTable.getScanner(family, qualifier);
    }

    public void put(Put put) throws IOException {
        this.checkStatus();
        this.ohTable.put(put);
    }

    public void put(List<Put> puts) throws IOException {
        this.checkStatus();
        this.ohTable.put(puts);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        this.checkStatus();
        return this.ohTable.checkAndPut(row, family, qualifier, value, put);
    }

    public void delete(Delete delete) throws IOException {
        this.checkStatus();
        this.ohTable.delete(delete);
    }

    public void delete(List<Delete> deletes) throws IOException {
        this.checkStatus();
        this.ohTable.delete(deletes);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        this.checkStatus();
        return this.ohTable.checkAndDelete(row, family, qualifier, value, delete);
    }

    public void mutateRow(RowMutations rm) throws IOException {
        this.checkStatus();
        this.ohTable.mutateRow(rm);
    }

    public Result append(Append append) throws IOException {
        this.checkStatus();
        return this.ohTable.append(append);
    }

    public Result increment(Increment increment) throws IOException {
        this.checkStatus();
        return this.ohTable.increment(increment);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        this.checkStatus();
        return this.ohTable.incrementColumnValue(row, family, qualifier, amount);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        this.checkStatus();
        return this.ohTable.incrementColumnValue(row, family, qualifier, amount, writeToWAL);
    }

    public boolean isAutoFlush() {
        this.checkStatus();
        return this.ohTable.isAutoFlush();
    }

    public void flushCommits() throws IOException {
        this.checkStatus();
        this.ohTable.flushCommits();
    }

    public String getTableNameString() {
        return this.tableNameString;
    }

    public void setTableNameString(String tableNameString) {
        this.tableNameString = tableNameString;
        this.tableName = tableNameString.getBytes();
    }

    public void refreshTableEntry(String familyString, boolean hasTestLoad) throws Exception {
        this.ohTable.refreshTableEntry(familyString, hasTestLoad);
    }

    public byte[][] getStartKeys() throws IOException {
        return this.ohTable.getStartKeys();
    }

    public byte[][] getEndKeys() throws IOException {
        return this.ohTable.getEndKeys();
    }

    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        return this.ohTable.getStartEndKeys();
    }
}

