/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.hbase.execute;

import com.alipay.oceanbase.rpc.ObTableClient;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.util.Bytes;

public abstract class ServerCallable<T>
implements Callable<T> {
    protected final Configuration conf;
    protected final ObTableClient obTableClient;
    protected final String tableNameString;
    protected int callTimeout;
    protected long globalStartTime;
    protected long endTime;
    protected byte[] startRow;
    protected byte[] endRow;

    public ServerCallable(Configuration conf, ObTableClient obTableClient, String tableNameString, byte[] startRow, byte[] endRow, int callTimeout) {
        this.conf = conf;
        this.obTableClient = obTableClient;
        this.tableNameString = tableNameString;
        this.callTimeout = callTimeout;
        this.startRow = startRow;
        this.endRow = endRow;
    }

    public void afterCall() {
        this.endTime = System.currentTimeMillis();
    }

    public void testConnectWhileIdle() {
    }

    public void shouldRetry(Throwable throwable) throws IOException {
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (this.callTimeout != Integer.MAX_VALUE && this.endTime - this.globalStartTime > (long)this.callTimeout) {
            throw (SocketTimeoutException)new SocketTimeoutException("Call to access row '" + Bytes.toString((byte[])this.startRow) + "' to '" + Bytes.toString((byte[])this.endRow) + "' on table '" + this.tableNameString + "' failed on socket timeout exception: " + throwable).initCause(throwable);
        }
    }

    ObTableClient getObTableClient() {
        return this.obTableClient;
    }

    public T withRetries() throws IOException, RuntimeException {
        long pause = this.conf.getLong(HConstants.HBASE_CLIENT_PAUSE, HConstants.DEFAULT_HBASE_CLIENT_PAUSE);
        int numRetries = this.conf.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
        this.globalStartTime = System.currentTimeMillis();
        ArrayList<RetriesExhaustedException.ThrowableWithExtraContext> exceptions = new ArrayList<RetriesExhaustedException.ThrowableWithExtraContext>();
        for (int tries = 0; tries < numRetries; ++tries) {
            try {
                this.testConnectWhileIdle();
                Object result = this.call();
                this.afterCall();
                return (T)result;
            }
            catch (Throwable t) {
                this.afterCall();
                this.shouldRetry(t);
                RetriesExhaustedException.ThrowableWithExtraContext qt = new RetriesExhaustedException.ThrowableWithExtraContext(t, System.currentTimeMillis(), this.toString());
                exceptions.add(qt);
                if (tries == numRetries - 1) {
                    StringBuilder buffer = new StringBuilder("Failed contacting ");
                    buffer.append(exceptions);
                    buffer.append(" after ");
                    buffer.append(tries + 1);
                    buffer.append(" attempts.\nExceptions:\n");
                    for (RetriesExhaustedException.ThrowableWithExtraContext e : exceptions) {
                        buffer.append(e.toString());
                        buffer.append("\n");
                    }
                    throw new RetriesExhaustedException(buffer.toString());
                }
                try {
                    Thread.sleep(ConnectionUtils.getPauseTime((long)pause, (int)tries));
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Giving up after tries=" + tries, e);
                }
            }
        }
        return null;
    }

    public T withoutRetries() throws IOException, RuntimeException {
        return this.withoutRetries(false);
    }

    public T withoutRetries(boolean testWhileIdle) throws IOException, RuntimeException {
        try {
            if (testWhileIdle) {
                this.testConnectWhileIdle();
            }
            Object v = this.call();
            return (T)v;
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new RuntimeException(t);
        }
        finally {
            this.afterCall();
        }
    }
}

