/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.hbase.util;

import com.alipay.oceanbase.hbase.OHTable;
import com.alipay.oceanbase.hbase.OHTablePool;
import com.alipay.oceanbase.hbase.util.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTableFactory;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.util.Bytes;

public class OHTableFactory
extends HTableFactory {
    private final ExecutorService threadPool;
    private final OHTablePool tablePool;

    public OHTableFactory(Configuration conf, OHTablePool tablePool) {
        this(conf, tablePool, OHTable.createDefaultThreadPoolExecutor(1, conf.getInt("hbase.htable.privatethreads.max", Integer.MAX_VALUE), conf.getLong("hbase.htable.threads.keepalivetime", 60L)));
    }

    public OHTableFactory(Configuration conf, OHTablePool tablePool, ExecutorService createTableThreadPool) {
        this.threadPool = createTableThreadPool;
        this.tablePool = tablePool;
    }

    public HTableInterface createHTableInterface(Configuration config, byte[] tableName) {
        try {
            String tableNameStr = Bytes.toString((byte[])tableName);
            OHTable ht = new OHTable(this.adjustConfiguration(this.copyConfiguration(config), tableNameStr), tableName, this.threadPool);
            if (this.tablePool.getTableAttribute(tableNameStr, "hbase.htable.pool.auto.flush") != null) {
                ht.setAutoFlush(this.tablePool.getAutoFlush(tableNameStr), this.tablePool.getClearBufferOnFail(tableNameStr));
            }
            if (this.tablePool.getTableAttribute(tableNameStr, "hbase.htable.pool.clear.buffer.on.fail") != null) {
                ht.setWriteBufferSize(this.tablePool.getWriteBufferSize(tableNameStr));
            }
            if (this.tablePool.getTableAttribute(tableNameStr, "hbase.htable.pool.operation.timeout") != null) {
                ht.setOperationTimeout(this.tablePool.getOperationTimeout(tableNameStr));
            }
            if (this.tablePool.getTableExtendAttribute(tableNameStr, "hbase.oceanbase.batch.executor") != null) {
                ht.setRuntimeBatchExecutor(this.tablePool.getRuntimeBatchExecutor(tableNameStr));
            }
            return ht;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private Configuration adjustConfiguration(Configuration configuration, String tableName) {
        byte[] isOdpModeAttr = this.tablePool.getTableAttribute(tableName, "hbase.oceanbase.odpMode");
        if (isOdpModeAttr != null && Bytes.toBoolean((byte[])isOdpModeAttr) || isOdpModeAttr == null && configuration.getBoolean("hbase.oceanbase.odpMode", false)) {
            configuration.setBoolean("hbase.oceanbase.odpMode", true);
            String odpAddr = this.tablePool.getOdpAddr(tableName);
            if (!odpAddr.isEmpty()) {
                configuration.set("hbase.oceanbase.odpAddr", odpAddr);
            }
            Preconditions.checkArgument(StringUtils.isNotBlank((String)configuration.get("hbase.oceanbase.odpAddr")), "hbase.oceanbase.odpAddr is blank");
            int odpPort = this.tablePool.getOdpPort(tableName);
            if (odpPort != -1) {
                configuration.setInt("hbase.oceanbase.odpPort", odpPort);
            }
            Preconditions.checkArgument(configuration.getInt("hbase.oceanbase.odpPort", -1) >= 0, "hbase.oceanbase.odpPort is invalid");
            String database = this.tablePool.getDatabase(tableName);
            if (!database.isEmpty()) {
                configuration.set("hbase.oceanbase.database", database);
            }
            Preconditions.checkArgument(StringUtils.isNotBlank((String)configuration.get("hbase.oceanbase.database")), "hbase.oceanbase.database is blank");
        } else {
            configuration.setBoolean("hbase.oceanbase.odpMode", false);
            String paramUrl = Bytes.toString((byte[])this.tablePool.getTableAttribute(tableName, "hbase.oceanbase.paramURL"));
            if (paramUrl != null) {
                configuration.set("hbase.oceanbase.paramURL", paramUrl);
            }
            Preconditions.checkArgument(StringUtils.isNotBlank((String)configuration.get("hbase.oceanbase.paramURL")), "table [" + tableName + "]" + "hbase.oceanbase.paramURL" + " is blank");
            String sysUserName = Bytes.toString((byte[])this.tablePool.getTableAttribute(tableName, "hbase.oceanbase.sysUserName"));
            if (sysUserName != null) {
                configuration.set("hbase.oceanbase.sysUserName", sysUserName);
            }
            Preconditions.checkArgument(StringUtils.isNotBlank((String)configuration.get("hbase.oceanbase.sysUserName")), "table [" + tableName + "]" + "hbase.oceanbase.sysUserName" + " is blank");
            String sysPassword = Bytes.toString((byte[])this.tablePool.getTableAttribute(tableName, "hbase.oceanbase.sysPassword"));
            if (sysPassword != null) {
                configuration.set("hbase.oceanbase.sysPassword", sysPassword);
            }
        }
        String fullUsername = Bytes.toString((byte[])this.tablePool.getTableAttribute(tableName, "hbase.oceanbase.fullUserName"));
        if (fullUsername != null) {
            configuration.set("hbase.oceanbase.fullUserName", fullUsername);
        }
        Preconditions.checkArgument(StringUtils.isNotBlank((String)configuration.get("hbase.oceanbase.fullUserName")), "table [" + tableName + "]" + "hbase.oceanbase.fullUserName" + " is blank");
        String password = Bytes.toString((byte[])this.tablePool.getTableAttribute(tableName, "hbase.oceanbase.password"));
        if (password != null) {
            configuration.set("hbase.oceanbase.password", password);
        }
        return configuration;
    }

    private Configuration copyConfiguration(Configuration origin) {
        Configuration copy = new Configuration();
        for (Map.Entry entry : origin) {
            copy.set((String)entry.getKey(), (String)entry.getValue());
        }
        return copy;
    }

    public void close() {
        if (this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.shutdown();
        }
    }
}

