/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.hbase.util;

import com.alipay.oceanbase.hbase.util.Preconditions;
import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.property.Property;
import com.google.common.base.Objects;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;

public class ObTableClientManager {
    public static final ConcurrentHashMap<ObTableClientKey, ReentrantLock> OB_TABLE_CLIENT_LOCK = new ConcurrentHashMap();
    public static final Map<ObTableClientKey, ObTableClient> OB_TABLE_CLIENT_INSTANCE = new ConcurrentHashMap<ObTableClientKey, ObTableClient>();

    public static ObTableClient getOrCreateObTableClient(Configuration conf) throws IllegalArgumentException, IOException {
        ObTableClientKey obTableClientKey = null;
        if (conf.getBoolean("hbase.oceanbase.odpMode", false)) {
            Preconditions.checkArgument(StringUtils.isNotBlank((String)conf.get("hbase.oceanbase.odpAddr")), "hbase.oceanbase.odpAddr is blank");
            Preconditions.checkArgument(conf.getInt("hbase.oceanbase.odpPort", -1) >= 0, "hbase.oceanbase.odpPort is invalid");
            Preconditions.checkArgument(StringUtils.isNotBlank((String)conf.get("hbase.oceanbase.database")), "hbase.oceanbase.database is blank");
            obTableClientKey = new ObTableClientKey();
            obTableClientKey.setOdpAddr(conf.get("hbase.oceanbase.odpAddr"));
            obTableClientKey.setOdpPort(conf.getInt("hbase.oceanbase.odpPort", -1));
            obTableClientKey.setOdpMode(true);
            obTableClientKey.setDatabase(conf.get("hbase.oceanbase.database"));
        } else {
            Preconditions.checkArgument(StringUtils.isNotBlank((String)conf.get("hbase.oceanbase.paramURL")), "hbase.oceanbase.paramURL is blank");
            obTableClientKey = new ObTableClientKey();
            obTableClientKey.setParamUrl(conf.get("hbase.oceanbase.paramURL"));
            obTableClientKey.setSysUserName(conf.get("hbase.oceanbase.sysUserName"));
            if (conf.get("hbase.oceanbase.sysPassword") == null) {
                obTableClientKey.setSysPassword("");
            } else {
                obTableClientKey.setSysPassword(conf.get("hbase.oceanbase.sysPassword"));
            }
        }
        Preconditions.checkArgument(StringUtils.isNotBlank((String)conf.get("hbase.oceanbase.fullUserName")), "hbase.oceanbase.fullUserName is blank");
        obTableClientKey.setFullUserName(conf.get("hbase.oceanbase.fullUserName"));
        if (conf.get("hbase.oceanbase.password") == null) {
            obTableClientKey.setPassword("");
        } else {
            obTableClientKey.setPassword(conf.get("hbase.oceanbase.password"));
        }
        for (Property property : Property.values()) {
            String value = conf.get(property.getKey());
            if (value == null) continue;
            obTableClientKey.getProperties().put(property.getKey(), value);
        }
        return ObTableClientManager.getOrCreateObTableClient(obTableClientKey);
    }

    public static ObTableClient getOrCreateObTableClient(ObTableClientKey obTableClientKey) throws IOException {
        if (OB_TABLE_CLIENT_INSTANCE.get(obTableClientKey) == null) {
            ReentrantLock tmp = new ReentrantLock();
            ReentrantLock lock = OB_TABLE_CLIENT_LOCK.putIfAbsent(obTableClientKey, tmp);
            lock = lock == null ? tmp : lock;
            lock.lock();
            try {
                if (OB_TABLE_CLIENT_INSTANCE.get(obTableClientKey) == null) {
                    ObTableClient obTableClient = new ObTableClient();
                    if (obTableClientKey.getOdpMode()) {
                        obTableClient.setOdpAddr(obTableClientKey.getOdpAddr());
                        obTableClient.setOdpPort(obTableClientKey.getOdpPort());
                        obTableClient.setOdpMode(obTableClientKey.getOdpMode());
                        obTableClient.setDatabase(obTableClientKey.getDatabase());
                        obTableClient.setProperties(obTableClientKey.getProperties());
                        obTableClient.setRunningMode(ObTableClient.RunningMode.HBASE);
                    } else {
                        obTableClient.setParamURL(obTableClientKey.getParamUrl());
                        obTableClient.setSysUserName(obTableClientKey.getSysUserName());
                        obTableClient.setSysPassword(obTableClientKey.getSysPassword());
                        obTableClient.setProperties(obTableClientKey.getProperties());
                        obTableClient.setRunningMode(ObTableClient.RunningMode.HBASE);
                    }
                    obTableClient.setFullUserName(obTableClientKey.getFullUserName());
                    obTableClient.setPassword(obTableClientKey.getPassword());
                    obTableClient.init();
                    OB_TABLE_CLIENT_INSTANCE.put(obTableClientKey, obTableClient);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                lock.unlock();
            }
        }
        return OB_TABLE_CLIENT_INSTANCE.get(obTableClientKey);
    }

    public static class ObTableClientKey {
        private String paramUrl;
        private String fullUserName;
        private String password;
        private String sysUserName;
        private String sysPassword;
        private String odpAddr;
        private int odpPort;
        private String database;
        private boolean odpMode = false;
        private Properties properties = new Properties();

        public String getParamUrl() {
            return this.paramUrl;
        }

        public void setParamUrl(String paramUrl) {
            this.paramUrl = paramUrl;
        }

        public String getFullUserName() {
            return this.fullUserName;
        }

        public void setFullUserName(String fullUserName) {
            this.fullUserName = fullUserName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getSysUserName() {
            return this.sysUserName;
        }

        public void setSysUserName(String sysUserName) {
            this.sysUserName = sysUserName;
        }

        public String getSysPassword() {
            return this.sysPassword;
        }

        public void setSysPassword(String sysPassword) {
            this.sysPassword = sysPassword;
        }

        public String getOdpAddr() {
            return this.odpAddr;
        }

        public void setOdpAddr(String odpAddr) {
            this.odpAddr = odpAddr;
        }

        public int getOdpPort() {
            return this.odpPort;
        }

        public void setOdpPort(int odpPort) {
            this.odpPort = odpPort;
        }

        public String getDatabase() {
            return this.database;
        }

        public void setDatabase(String database) {
            this.database = database;
        }

        public boolean getOdpMode() {
            return this.odpMode;
        }

        public void setOdpMode(boolean odpMode) {
            this.odpMode = odpMode;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObTableClientKey that = (ObTableClientKey)o;
            boolean ans = false;
            ans = this.odpMode ? Objects.equal((Object)this.fullUserName, (Object)that.fullUserName) && Objects.equal((Object)this.password, (Object)that.password) && Objects.equal((Object)this.odpAddr, (Object)that.odpAddr) && this.odpPort == that.odpPort && Objects.equal((Object)this.database, (Object)that.database) : Objects.equal((Object)this.paramUrl, (Object)that.paramUrl) && Objects.equal((Object)this.fullUserName, (Object)that.fullUserName) && Objects.equal((Object)this.password, (Object)that.password) && Objects.equal((Object)this.sysUserName, (Object)that.sysUserName) && Objects.equal((Object)this.sysPassword, (Object)that.sysPassword);
            return ans;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.paramUrl, this.fullUserName, this.password, this.sysUserName, this.sysPassword});
        }
    }
}

