/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.bolt.protocol;

import com.alipay.oceanbase.rpc.protocol.packet.ObRpcPacketHeader;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObTableDirectLoadResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.mutate.ObTableQueryAndMutateResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObTableQueryAsyncResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.login.ObTableLoginResult;
import com.alipay.remoting.CommandCode;

public enum ObTablePacketCode implements CommandCode
{
    OB_TABLE_API_LOGIN(4353){

        @Override
        public ObPayload newPayload(ObRpcPacketHeader header) {
            return new ObTableLoginResult();
        }
    }
    ,
    OB_TABLE_API_EXECUTE(4354){

        @Override
        public ObPayload newPayload(ObRpcPacketHeader header) {
            return new ObTableOperationResult();
        }
    }
    ,
    OB_TABLE_API_BATCH_EXECUTE(4355){

        @Override
        public ObPayload newPayload(ObRpcPacketHeader header) {
            return new ObTableBatchOperationResult();
        }
    }
    ,
    OB_TABLE_API_EXECUTE_QUERY(4356){

        @Override
        public ObPayload newPayload(ObRpcPacketHeader header) {
            return new ObTableQueryResult(header);
        }
    }
    ,
    OB_TABLE_API_QUERY_AND_MUTATE(4357){

        @Override
        public ObPayload newPayload(ObRpcPacketHeader header) {
            return new ObTableQueryAndMutateResult();
        }
    }
    ,
    OB_TABLE_API_EXECUTE_QUERY_SYNC(4358){

        @Override
        public ObPayload newPayload(ObRpcPacketHeader header) {
            return new ObTableQueryAsyncResult();
        }
    }
    ,
    OB_TABLE_API_DIRECT_LOAD(4387){

        @Override
        public ObPayload newPayload(ObRpcPacketHeader header) {
            return new ObTableDirectLoadResult();
        }
    }
    ,
    OB_ERROR_PACKET(16){

        @Override
        public ObPayload newPayload(ObRpcPacketHeader header) {
            throw new IllegalArgumentException("OB_ERROR_PACKET has no payload implementation");
        }
    };

    private short value;

    private ObTablePacketCode(int value) {
        this.value = (short)value;
    }

    public short value() {
        return this.value;
    }

    public static ObTablePacketCode valueOf(short value) {
        switch (value) {
            case 4353: {
                return OB_TABLE_API_LOGIN;
            }
            case 4354: {
                return OB_TABLE_API_EXECUTE;
            }
            case 4355: {
                return OB_TABLE_API_BATCH_EXECUTE;
            }
            case 4356: {
                return OB_TABLE_API_EXECUTE_QUERY;
            }
            case 4357: {
                return OB_TABLE_API_QUERY_AND_MUTATE;
            }
            case 4358: {
                return OB_TABLE_API_EXECUTE_QUERY_SYNC;
            }
            case 4387: {
                return OB_TABLE_API_DIRECT_LOAD;
            }
            case 16: {
                return OB_ERROR_PACKET;
            }
        }
        throw new IllegalArgumentException("Unknown Rpc command code value ," + value);
    }

    public abstract ObPayload newPayload(ObRpcPacketHeader var1);
}

