/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.exception;

import com.alipay.oceanbase.rpc.exception.ObTableAuthException;
import com.alipay.oceanbase.rpc.exception.ObTableDuplicateKeyException;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTableMasterChangeException;
import com.alipay.oceanbase.rpc.exception.ObTableNoReadableReplicaException;
import com.alipay.oceanbase.rpc.exception.ObTableNotExistException;
import com.alipay.oceanbase.rpc.exception.ObTablePartitionChangeException;
import com.alipay.oceanbase.rpc.exception.ObTableReplicaNotReadableException;
import com.alipay.oceanbase.rpc.exception.ObTableServerDownException;
import com.alipay.oceanbase.rpc.exception.ObTableServerStatusChangeException;
import com.alipay.oceanbase.rpc.exception.ObTableServerTimeoutException;
import com.alipay.oceanbase.rpc.exception.ObTableTransactionRpcTimeout;
import com.alipay.oceanbase.rpc.exception.ObTableTransportException;
import com.alipay.oceanbase.rpc.exception.ObTableUnexpectedException;
import com.alipay.oceanbase.rpc.exception.ObTableUnitMigrateException;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;

public class ExceptionUtil {
    public static void throwObTableException(int errorCode) {
        if (errorCode != ResultCodes.OB_SUCCESS.errorCode) {
            throw ExceptionUtil.convertToObTableException("", 0, 0L, 0L, errorCode);
        }
    }

    public static void throwObTableException(String host, int port, long sequence, long uniqueId, int errorCode) {
        if (errorCode != ResultCodes.OB_SUCCESS.errorCode) {
            throw ExceptionUtil.convertToObTableException(host, port, sequence, uniqueId, errorCode);
        }
    }

    public static ObTableException convertToObTableException(String host, int port, long sequence, long uniqueId, int errorCode) {
        String trace = String.format("Y%X-%016X", uniqueId, sequence);
        String server = host + ":" + port;
        ResultCodes resultCodes = ResultCodes.valueOf(errorCode);
        if (resultCodes == null) {
            return new ObTableUnexpectedException("[" + trace + "] [unknown errcode: " + errorCode + "] server [" + server + "]", errorCode);
        }
        switch (resultCodes) {
            case OB_ERR_PRIMARY_KEY_DUPLICATE: {
                return new ObTableDuplicateKeyException("[" + trace + "] [" + resultCodes.name() + "] server [" + server + "] ", resultCodes.errorCode);
            }
            case OB_ERR_UNKNOWN_TABLE: {
                return new ObTableNotExistException("[" + trace + "] [OB_ERR_UNKNOWN_TABLE] server [" + server + "]table not exist", resultCodes.errorCode);
            }
            case OB_ERR_COLUMN_NOT_FOUND: {
                return new ObTableException("[" + trace + "] [OB_ERR_COLUMN_NOT_FOUND] server [" + server + "]column not found", resultCodes.errorCode);
            }
            case OB_OBJ_TYPE_ERROR: {
                return new ObTableException("[" + trace + "] [OB_OBJ_TYPE_ERROR] server [" + server + "]rowkey/column type not match", resultCodes.errorCode);
            }
            case OB_BAD_NULL_ERROR: {
                return new ObTableException("[" + trace + "] [OB_BAD_NULL_ERROR] server [" + server + "]column doesn't have a default value", resultCodes.errorCode);
            }
            case OB_INVALID_ARGUMENT: {
                return new ObTableException("[" + trace + "] [OB_INVALID_ARGUMENT] server [" + server + "]ob table arguments invalid", resultCodes.errorCode);
            }
            case OB_DESERIALIZE_ERROR: {
                return new ObTableAuthException("[" + trace + "] [OB_DESERIALIZE_ERROR] server [" + server + "]maybe invalid username, errorCode: " + (Object)((Object)ResultCodes.OB_DESERIALIZE_ERROR), resultCodes.errorCode);
            }
            case OB_PASSWORD_WRONG: {
                return new ObTableAuthException("[" + trace + "] [OB_PASSWORD_WRONG] server [" + server + "]access deny", resultCodes.errorCode);
            }
            case OB_LOCATION_LEADER_NOT_EXIST: 
            case OB_NOT_MASTER: 
            case OB_RS_NOT_MASTER: 
            case OB_RS_SHUTDOWN: {
                return new ObTableMasterChangeException("[" + trace + "] [" + resultCodes.name() + "] server [" + server + "]", resultCodes.errorCode);
            }
            case OB_RPC_CONNECT_ERROR: {
                return new ObTableServerDownException("[" + trace + "] [" + resultCodes.name() + "] server [" + server + "]", resultCodes.errorCode);
            }
            case OB_PARTITION_NOT_EXIST: 
            case OB_PARTITION_IS_STOPPED: 
            case OB_LOCATION_NOT_EXIST: {
                return new ObTablePartitionChangeException("[" + trace + "] [" + resultCodes.name() + "] server [" + server + "]", resultCodes.errorCode);
            }
            case OB_SERVER_IS_INIT: 
            case OB_SERVER_IS_STOPPING: {
                return new ObTableServerStatusChangeException("[" + trace + "] [" + resultCodes.name() + "] server [" + server + "]", resultCodes.errorCode);
            }
            case OB_TENANT_NOT_IN_SERVER: {
                return new ObTableUnitMigrateException("[" + trace + "] [" + resultCodes.name() + "] server [" + server + "]", resultCodes.errorCode);
            }
            case OB_TRANS_RPC_TIMEOUT: {
                return new ObTableTransactionRpcTimeout("[" + trace + "] [" + resultCodes.name() + "] server [" + server + "]", resultCodes.errorCode);
            }
            case OB_NO_READABLE_REPLICA: {
                return new ObTableNoReadableReplicaException("[" + trace + "] [" + resultCodes.name() + "] server [" + server + "]", resultCodes.errorCode);
            }
            case OB_REPLICA_NOT_READABLE: {
                return new ObTableReplicaNotReadableException("[" + trace + "] [" + resultCodes.name() + "] server [" + server + "]", resultCodes.errorCode);
            }
            case OB_TIMEOUT: 
            case OB_TRANS_TIMEOUT: 
            case OB_WAITQUEUE_TIMEOUT: {
                return new ObTableServerTimeoutException("[" + trace + "] [" + resultCodes.name() + "] server [" + server + "]", resultCodes.errorCode);
            }
        }
        return new ObTableUnexpectedException("[" + trace + "] [" + resultCodes.name() + "] server [" + server + "]", resultCodes.errorCode);
    }

    public static void throwObTableTransportException(String message, int errorCode) {
        switch (errorCode) {
            case 0: {
                return;
            }
            case -20004: 
            case -20003: 
            case -20002: 
            case -20001: {
                throw new ObTableTransportException(message, errorCode);
            }
        }
        throw new ObTableTransportException("unexpected transport exception: " + errorCode, errorCode);
    }
}

