/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.exception;

public class ObTableException
extends RuntimeException {
    private int errorCode;
    private boolean needRefreshTableEntry;

    public ObTableException() {
    }

    public ObTableException(int errorCode) {
        this("error code: " + errorCode, errorCode);
    }

    public ObTableException(String message, int errorCode) {
        this(message);
        this.errorCode = errorCode;
    }

    public ObTableException(String message) {
        super(message);
    }

    public ObTableException(String message, Throwable cause) {
        super(message, cause);
        if (cause instanceof ObTableException) {
            this.errorCode = ((ObTableException)cause).getErrorCode();
            this.needRefreshTableEntry = ((ObTableException)cause).isNeedRefreshTableEntry();
        }
    }

    public ObTableException(Throwable cause) {
        super(cause);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public boolean isNeedRefreshTableEntry() {
        return this.needRefreshTableEntry;
    }
}

