/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.filter;

import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.filter.ObTableFilter;
import com.alipay.oceanbase.rpc.filter.ObTableValueFilter;
import java.util.ArrayList;
import java.util.List;

public class ObTableFilterList
extends ObTableFilter {
    private operator op;
    private List<ObTableFilter> filters;

    public ObTableFilterList() {
        this.op = operator.AND;
        this.filters = new ArrayList<ObTableFilter>();
    }

    public ObTableFilterList(operator op) {
        if (null == op) {
            throw new ObTableException("operator is null");
        }
        this.op = op;
        this.filters = new ArrayList<ObTableFilter>();
    }

    public ObTableFilterList(operator op, ObTableFilter ... filters) {
        if (null == op) {
            throw new ObTableException("operator is null");
        }
        this.op = op;
        this.filters = new ArrayList<ObTableFilter>();
        for (int i = 0; i < filters.length; ++i) {
            if (null == filters[i]) {
                throw new ObTableException(i + "-th filter is null");
            }
            this.filters.add(filters[i]);
        }
    }

    public void addFilter(ObTableFilter ... filters) {
        for (int i = 0; i < filters.length; ++i) {
            if (null == filters[i] || this == filters[i]) {
                throw new ObTableException(i + "-th input filter is illegal ");
            }
            this.filters.add(filters[i]);
        }
    }

    public int size() {
        return this.filters.size();
    }

    public ObTableFilter get(int pos) {
        if (pos >= this.size()) {
            throw new ObTableException("pos:" + pos + " is out of range: " + this.size());
        }
        return this.filters.get(pos);
    }

    @Override
    public String toString() {
        StringBuilder filtersString = new StringBuilder();
        String stringOp = operator.AND == this.op ? " && " : " || ";
        for (int i = 0; i < this.filters.size(); ++i) {
            String filterString = this.filters.get(i).toString();
            if (null == filterString || filterString.isEmpty()) continue;
            if (0 != i) {
                filtersString.append(stringOp);
            }
            if (this.filters.get(i) instanceof ObTableValueFilter) {
                filtersString.append(filterString);
                continue;
            }
            filtersString.append("(");
            filtersString.append(filterString);
            filtersString.append(")");
        }
        return filtersString.toString();
    }

    public static enum operator {
        AND,
        OR;

    }
}

