/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model;

import com.alipay.oceanbase.rpc.location.model.ObServerLdcItem;
import com.alipay.oceanbase.rpc.util.StringUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ObServerLdcLocation {
    private String currentIDC;
    private Set<String> regionNames = new HashSet<String>();
    private RegionMatchType matchType;
    private boolean isLdcUsed;
    private List<ObServerLdcItem> allServers;
    private HashMap<String, ObServerLdcItem> sameIDC = new HashMap();
    private HashMap<String, ObServerLdcItem> sameRegion = new HashMap();
    private HashMap<String, ObServerLdcItem> otherRegion = new HashMap();

    public static ObServerLdcLocation buildLdcLocation(List<ObServerLdcItem> allServers, String currentIDC, String regionFromOcp) {
        ObServerLdcLocation loc = new ObServerLdcLocation();
        loc.allServers = allServers;
        loc.currentIDC = currentIDC;
        if (StringUtil.isEmpty(currentIDC)) {
            loc.isLdcUsed = false;
        } else {
            for (ObServerLdcItem ss : allServers) {
                if (!ss.getIdc().equalsIgnoreCase(currentIDC)) continue;
                loc.regionNames.add(ss.getRegion());
                loc.matchType = RegionMatchType.MATCHED_BY_IDC;
            }
            if (loc.regionNames.isEmpty()) {
                for (ObServerLdcItem ss : allServers) {
                    if (!ss.getZone().startsWith(currentIDC)) continue;
                    loc.regionNames.add(ss.getRegion());
                    loc.matchType = RegionMatchType.MATCHED_BY_ZONE_PREFIX;
                }
            }
            if (loc.regionNames.isEmpty() && StringUtil.isNotEmpty(regionFromOcp)) {
                loc.regionNames.add(regionFromOcp);
                loc.matchType = RegionMatchType.MATCHED_BY_URL;
            }
            if (!loc.regionNames.isEmpty()) {
                loc.isLdcUsed = true;
            }
        }
        if (loc.isLdcUsed) {
            for (ObServerLdcItem it : allServers) {
                if (it.getIdc().equalsIgnoreCase(currentIDC)) {
                    loc.sameIDC.put(it.getIp(), it);
                    continue;
                }
                if (loc.regionNames.contains(it.getRegion())) {
                    loc.sameRegion.put(it.getIp(), it);
                    continue;
                }
                loc.otherRegion.put(it.getIp(), it);
            }
        }
        return loc;
    }

    public boolean inSameIDC(String svr_ip) {
        return this.sameIDC.containsKey(svr_ip);
    }

    public boolean inSameRegion(String ip) {
        return this.sameRegion.containsKey(ip);
    }

    public boolean inOtherRegion(String ip) {
        return this.otherRegion.containsKey(ip);
    }

    public boolean isLdcUsed() {
        return this.isLdcUsed;
    }

    public String getCurrentIDC() {
        return this.currentIDC;
    }

    public RegionMatchType getMatchType() {
        return this.matchType;
    }

    public String toString() {
        return "ObServerLdcLocation{currentIDC='" + this.currentIDC + '\'' + ", isLdcUsed=" + this.isLdcUsed + ", regionNames=" + this.regionNames + ", matchType=" + (Object)((Object)this.matchType) + ", allServers=" + this.allServers + ", sameIDC=" + this.sameIDC + ", sameRegion=" + this.sameRegion + ", otherRegion=" + this.otherRegion + '}';
    }

    static enum RegionMatchType {
        MATCHED_BY_IDC,
        MATCHED_BY_ZONE_PREFIX,
        MATCHED_BY_URL;

    }
}

