/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model;

import com.alipay.oceanbase.rpc.location.model.ObServerLdcLocation;
import com.alipay.oceanbase.rpc.location.model.TableEntryKey;
import com.alipay.oceanbase.rpc.location.model.TableLocation;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartitionEntry;
import com.alipay.oceanbase.rpc.location.model.partition.ObPartitionInfo;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;

public class TableEntry {
    public static final Map<String, Integer> HBASE_ROW_KEY_ELEMENT = new HashMap<String, Integer>(){
        {
            this.put("K", 0);
            this.put("Q", 1);
            this.put("T", 2);
        }
    };
    private Long tableId = -1L;
    private Long partitionNum = -1L;
    private Long replicaNum = -1L;
    private ObPartitionInfo partitionInfo = null;
    private volatile long refreshTimeMills;
    private Map<String, Integer> rowKeyElement = null;
    private TableLocation tableLocation = null;
    private TableEntryKey tableEntryKey = null;
    private volatile ObPartitionEntry partitionEntry = null;

    public boolean isValid() {
        return this.partitionNum > 0L && this.replicaNum > 0L && this.tableId > 0L && null != this.tableLocation && this.tableLocation.getReplicaLocations().size() > 0;
    }

    public Long getTableId() {
        return this.tableId;
    }

    public void setTableId(Long tableId) {
        this.tableId = tableId;
    }

    public Long getPartitionNum() {
        return this.partitionNum;
    }

    public void setPartitionNum(Long partitionNum) {
        this.partitionNum = partitionNum;
    }

    public Long getReplicaNum() {
        return this.replicaNum;
    }

    public boolean isPartitionTable() {
        return this.partitionNum > 1L;
    }

    public void setReplicaNum(Long replicaNum) {
        this.replicaNum = replicaNum;
    }

    public TableLocation getTableLocation() {
        return this.tableLocation;
    }

    public void setTableLocation(TableLocation tableLocation) {
        this.tableLocation = tableLocation;
    }

    public ObPartitionInfo getPartitionInfo() {
        return this.partitionInfo;
    }

    public void setPartitionInfo(ObPartitionInfo partitionInfo) {
        this.partitionInfo = partitionInfo;
    }

    public long getRefreshTimeMills() {
        return this.refreshTimeMills;
    }

    public void setRefreshTimeMills(long refreshTimeMills) {
        this.refreshTimeMills = refreshTimeMills;
    }

    public Map<String, Integer> getRowKeyElement() {
        return this.rowKeyElement;
    }

    public void setRowKeyElement(Map<String, Integer> rowKeyElement) {
        this.rowKeyElement = rowKeyElement;
        if (this.partitionInfo != null) {
            this.partitionInfo.setRowKeyElement(rowKeyElement);
        }
    }

    public TableEntryKey getTableEntryKey() {
        return this.tableEntryKey;
    }

    public void setTableEntryKey(TableEntryKey tableEntryKey) {
        this.tableEntryKey = tableEntryKey;
    }

    public ObPartitionEntry getPartitionEntry() {
        return this.partitionEntry;
    }

    public void setPartitionEntry(ObPartitionEntry partitionEntry) {
        this.partitionEntry = partitionEntry;
    }

    public void prepare() throws IllegalArgumentException {
        if (this.isPartitionTable()) {
            Preconditions.checkArgument((this.partitionInfo != null ? 1 : 0) != 0, (Object)("partition table partition info is not ready. key" + this.tableEntryKey));
            this.partitionInfo.prepare();
            Preconditions.checkArgument((this.partitionEntry != null ? 1 : 0) != 0, (Object)("partition table partition entry is not ready. key" + this.tableEntryKey));
        }
    }

    public void prepareForWeakRead(ObServerLdcLocation ldcLocation) {
        if (this.partitionEntry != null) {
            this.partitionEntry.prepareForWeakRead(ldcLocation);
        }
    }

    public String toString() {
        return "TableEntry{tableId=" + this.tableId + ", partitionNum=" + this.partitionNum + ", replicaNum=" + this.replicaNum + ", partitionInfo=" + this.partitionInfo + ", refreshTimeMills=" + this.refreshTimeMills + ", rowKeyElement=" + this.rowKeyElement + ", tableLocation=" + this.tableLocation + ", tableEntryKey=" + this.tableEntryKey + ", partitionEntry=" + this.partitionEntry + '}';
    }
}

