/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.location.model.partition;

public enum ObPartFuncType {
    UNKNOWN("UNKNOWN", -1L),
    HASH("HASH", 0L),
    KEY("KEY", 1L),
    KEY_IMPLICIT("KEY_IMPLICIT", 2L),
    RANGE("RANGE", 3L),
    RANGE_COLUMNS("RANGE_COLUMNS", 4L),
    LIST("LIST", 5L),
    KEY_V2("KEY_V2", 6L),
    LIST_COLUMNS("LIST_COLUMNS", 7L),
    HASH_V2("HASH_V2", 8L),
    KEY_V3("KEY_V3", 9L),
    KEY_IMPLICIT_V2("KEY_IMPLICIT_V2", 10L);

    private final String name;
    private final long index;

    private ObPartFuncType(String name, long index) {
        this.name = name;
        this.index = index;
    }

    public static ObPartFuncType getObPartFuncType(long index) {
        if (ObPartFuncType.HASH.index == index) {
            return HASH;
        }
        if (ObPartFuncType.KEY.index == index) {
            return KEY;
        }
        if (ObPartFuncType.KEY_IMPLICIT.index == index) {
            return KEY_IMPLICIT;
        }
        if (ObPartFuncType.RANGE.index == index) {
            return RANGE;
        }
        if (ObPartFuncType.RANGE_COLUMNS.index == index) {
            return RANGE_COLUMNS;
        }
        if (ObPartFuncType.LIST.index == index) {
            return LIST;
        }
        if (ObPartFuncType.KEY_V2.index == index) {
            return KEY_V2;
        }
        if (ObPartFuncType.LIST_COLUMNS.index == index) {
            return LIST_COLUMNS;
        }
        if (ObPartFuncType.HASH_V2.index == index) {
            return HASH_V2;
        }
        if (ObPartFuncType.KEY_V3.index == index) {
            return KEY_V3;
        }
        if (ObPartFuncType.KEY_IMPLICIT_V2.index == index) {
            return KEY_IMPLICIT_V2;
        }
        return UNKNOWN;
    }

    public static ObPartFuncType getObPartFuncType(String name) {
        if (ObPartFuncType.HASH.name.equalsIgnoreCase(name)) {
            return HASH;
        }
        if (ObPartFuncType.KEY.name.equalsIgnoreCase(name)) {
            return KEY;
        }
        if (ObPartFuncType.KEY_IMPLICIT.name.equalsIgnoreCase(name)) {
            return KEY_IMPLICIT;
        }
        if (ObPartFuncType.RANGE.name.equalsIgnoreCase(name)) {
            return RANGE;
        }
        if (ObPartFuncType.RANGE_COLUMNS.name.equalsIgnoreCase(name)) {
            return RANGE_COLUMNS;
        }
        if (ObPartFuncType.LIST.name.equalsIgnoreCase(name)) {
            return LIST;
        }
        if (ObPartFuncType.KEY_V2.name.equalsIgnoreCase(name)) {
            return KEY_V2;
        }
        if (ObPartFuncType.LIST_COLUMNS.name.equalsIgnoreCase(name)) {
            return LIST_COLUMNS;
        }
        if (ObPartFuncType.HASH_V2.name.equalsIgnoreCase(name)) {
            return HASH_V2;
        }
        if (ObPartFuncType.KEY_V3.name.equalsIgnoreCase(name)) {
            return KEY_V3;
        }
        if (ObPartFuncType.KEY_IMPLICIT_V2.name.equalsIgnoreCase(name)) {
            return KEY_IMPLICIT_V2;
        }
        return UNKNOWN;
    }

    public long getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRangePart() {
        return this.index == RANGE.getIndex() || this.index == RANGE_COLUMNS.getIndex();
    }

    public boolean isHashPart() {
        return this.index == HASH.getIndex() || this.index == HASH_V2.getIndex();
    }

    public boolean isKeyPart() {
        return this.index == KEY_IMPLICIT_V2.getIndex() || this.index == KEY_IMPLICIT.getIndex() || this.index == KEY_V2.getIndex() || this.index == KEY_V3.getIndex() || this.index == KEY.getIndex();
    }

    public boolean isListPart() {
        return this.index == LIST.getIndex() || this.index == LIST_COLUMNS.getIndex();
    }
}

