/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload;

import com.alipay.oceanbase.rpc.property.Property;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractPayload
implements ObPayload {
    private static final AtomicInteger CHANNELID = new AtomicInteger(1);
    private long uniqueId;
    private long sequence;
    private Integer channelId = null;
    protected long tenantId = 1L;
    private long version = 1L;
    protected long timeout = Property.RPC_OPERATION_TIMEOUT.getDefaultLong();

    @Override
    public int getPcode() {
        return 16;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setChannelId(Integer channelId) {
        this.channelId = channelId;
    }

    @Override
    public long getPayloadSize() {
        long payloadContentSize = this.getPayloadContentSize();
        return Serialization.getObUniVersionHeaderLength(this.getVersion(), payloadContentSize) + payloadContentSize;
    }

    @Override
    public int getChannelId() {
        if (this.channelId == null) {
            this.channelId = CHANNELID.getAndIncrement();
        }
        return this.channelId;
    }

    @Override
    public long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Object decode(ByteBuf buf) {
        this.version = Serialization.decodeVi64(buf);
        Serialization.decodeVi64(buf);
        return this;
    }

    @Override
    public long getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void setUniqueId(long uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Override
    public long getSequence() {
        return this.sequence;
    }

    @Override
    public void setSequence(long sequence) {
        this.sequence = sequence;
    }
}

