/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.protocol.payload.ObRpcResultWarningMsg;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class ObRpcResultCode
extends AbstractPayload {
    private int rcode;
    private byte[] msg = new byte[0];
    private List<ObRpcResultWarningMsg> warningMsgs = new ArrayList<ObRpcResultWarningMsg>();

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        int headerLen = (int)Serialization.getObUniVersionHeaderLength(this.getVersion(), this.getPayloadContentSize());
        System.arraycopy(Serialization.encodeObUniVersionHeader(this.getVersion(), this.getPayloadContentSize()), 0, bytes, idx, headerLen);
        int len = Serialization.getNeedBytes(this.rcode);
        System.arraycopy(Serialization.encodeVi32(this.rcode), 0, bytes, idx += headerLen, len);
        idx += len;
        len = Serialization.getNeedBytes(this.msg.length);
        System.arraycopy(Serialization.encodeVi32(this.msg.length), 0, bytes, idx, len);
        System.arraycopy(this.msg, 0, bytes, idx += len, this.msg.length);
        len = Serialization.getNeedBytes(this.warningMsgs.size());
        System.arraycopy(Serialization.encodeVi32(this.warningMsgs.size()), 0, bytes, idx += this.msg.length, len);
        idx += len;
        for (ObRpcResultWarningMsg msg : this.warningMsgs) {
            System.arraycopy(msg.encode(), 0, bytes, idx, (int)msg.getPayloadSize());
        }
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        this.rcode = Serialization.decodeVi32(buf);
        int len = Serialization.decodeVi32(buf);
        this.msg = new byte[len];
        buf.readBytes(this.msg);
        len = Serialization.decodeVi32(buf);
        if (len > 0) {
            ObRpcResultWarningMsg msg = new ObRpcResultWarningMsg();
            msg.decode(buf);
            this.warningMsgs.add(msg);
        }
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        int size = Serialization.getNeedBytes(this.rcode) + Serialization.getNeedBytes(this.msg.length) + this.msg.length + Serialization.getNeedBytes(this.warningMsgs.size());
        if (this.warningMsgs.size() > 0) {
            for (ObRpcResultWarningMsg msg : this.warningMsgs) {
                size = (int)((long)size + msg.getPayloadSize());
            }
        }
        return size;
    }

    public int getRcode() {
        return this.rcode;
    }

    public void setRcode(int rcode) {
        this.rcode = rcode;
    }

    public byte[] getMsg() {
        return this.msg;
    }

    public void setMsg(byte[] msg) {
        this.msg = msg;
    }

    public List<ObRpcResultWarningMsg> getWarningMsgs() {
        return this.warningMsgs;
    }

    public void setWarningMsgs(List<ObRpcResultWarningMsg> warningMsgs) {
        this.warningMsgs = warningMsgs;
    }
}

