/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObRpcResultWarningMsg
extends AbstractPayload {
    private byte[] msg = new byte[0];
    private long timestamp;
    private int logLevel;
    private int lineNo;
    private int code;

    @Override
    public int getPcode() {
        return 0;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        int headerLen = (int)Serialization.getObUniVersionHeaderLength(this.getVersion(), this.getPayloadContentSize());
        System.arraycopy(Serialization.encodeObUniVersionHeader(this.getVersion(), this.getPayloadContentSize()), 0, bytes, idx, headerLen);
        int len = Serialization.getNeedBytes(this.msg.length);
        System.arraycopy(Serialization.encodeVi32(this.msg.length), 0, bytes, idx += headerLen, len);
        System.arraycopy(this.msg, 0, bytes, idx += len, this.msg.length);
        len = Serialization.getNeedBytes(this.timestamp);
        System.arraycopy(Serialization.encodeVi64(this.timestamp), 0, bytes, idx += this.msg.length, len);
        idx += len;
        len = Serialization.getNeedBytes(this.logLevel);
        System.arraycopy(Serialization.encodeVi32(this.logLevel), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.lineNo);
        System.arraycopy(Serialization.encodeVi32(this.lineNo), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.code);
        System.arraycopy(Serialization.encodeVi32(this.code), 0, bytes, idx, len);
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        int len = Serialization.decodeVi32(buf);
        this.msg = new byte[len];
        buf.readBytes(this.msg);
        this.timestamp = Serialization.decodeVi64(buf);
        this.logLevel = Serialization.decodeVi32(buf);
        this.lineNo = Serialization.decodeVi32(buf);
        this.code = Serialization.decodeVi32(buf);
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        return Serialization.getNeedBytes(this.msg.length) + this.msg.length + Serialization.getNeedBytes(this.timestamp) + Serialization.getNeedBytes(this.logLevel) + Serialization.getNeedBytes(this.lineNo) + Serialization.getNeedBytes(this.code);
    }

    public byte[] getMsg() {
        return this.msg;
    }

    public void setMsg(byte[] msg) {
        this.msg = msg;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }
}

