/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableAbstractOperationRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableConsistencyLevel;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntityType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOptionFlag;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;

public class ObTableBatchOperationRequest
extends ObTableAbstractOperationRequest {
    private ObTableBatchOperation batchOperation;
    private boolean batchOperationAsAtomic = false;

    @Override
    public int getPcode() {
        return 4355;
    }

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        idx = this.encodeHeader(bytes, idx);
        idx = this.encodeCredential(bytes, idx);
        idx = this.encodeTableMetaWithoutPartitionId(bytes, idx);
        int len = (int)this.batchOperation.getPayloadSize();
        System.arraycopy(this.batchOperation.encode(), 0, bytes, idx, len);
        System.arraycopy(Serialization.encodeI8(this.consistencyLevel.getByteValue()), 0, bytes, idx += len, 1);
        System.arraycopy(Serialization.encodeI8(this.option_flag.getByteValue()), 0, bytes, ++idx, 1);
        System.arraycopy(Serialization.encodeI8(this.returningAffectedEntity ? (byte)1 : 0), 0, bytes, ++idx, 1);
        System.arraycopy(Serialization.encodeI8(this.returningAffectedRows ? (byte)1 : 0), 0, bytes, ++idx, 1);
        ++idx;
        if (ObGlobal.obVsnMajor() >= 4) {
            System.arraycopy(Serialization.encodeI64(this.partitionId), 0, bytes, idx, 8);
            idx += 8;
        } else {
            len = Serialization.getNeedBytes(this.partitionId);
            System.arraycopy(Serialization.encodeVi64(this.partitionId), 0, bytes, idx, len);
            idx += len;
        }
        System.arraycopy(Serialization.encodeI8(this.batchOperationAsAtomic ? (byte)1 : 0), 0, bytes, idx, 1);
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        this.credential = Serialization.decodeBytesString(buf);
        this.tableName = Serialization.decodeVString(buf);
        this.tableId = Serialization.decodeVi64(buf);
        this.entityType = ObTableEntityType.valueOf(buf.readByte());
        this.batchOperation = new ObTableBatchOperation();
        this.batchOperation.decode(buf);
        this.consistencyLevel = ObTableConsistencyLevel.valueOf(buf.readByte());
        this.option_flag = ObTableOptionFlag.valueOf(buf.readByte());
        this.returningAffectedEntity = Serialization.decodeI8(buf) != 0;
        this.returningAffectedRows = Serialization.decodeI8(buf) != 0;
        this.partitionId = ObGlobal.obVsnMajor() >= 4 ? Serialization.decodeI64(buf) : Serialization.decodeVi64(buf);
        this.batchOperationAsAtomic = Serialization.decodeI8(buf) != 0;
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        return super.getPayloadContentSize() + this.batchOperation.getPayloadSize() + 1L;
    }

    public ObTableBatchOperation getBatchOperation() {
        return this.batchOperation;
    }

    public void setBatchOperation(ObTableBatchOperation batchOperation) {
        this.batchOperation = batchOperation;
    }

    public boolean isBatchOperationAsAtomic() {
        return this.batchOperationAsAtomic;
    }

    public void setBatchOperationAsAtomic(boolean batchOperationAsAtomic) {
        this.batchOperationAsAtomic = batchOperationAsAtomic;
    }
}

