/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query;

import com.alipay.oceanbase.rpc.protocol.payload.AbstractPayload;
import com.alipay.oceanbase.rpc.util.ObBytesString;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class ObHTableFilter
extends AbstractPayload {
    private boolean isValid = true;
    private List<ObBytesString> selectColumnQualifier = new ArrayList<ObBytesString>();
    private long minStamp = 0L;
    private long maxStamp = Long.MAX_VALUE;
    private int maxVersions = 1;
    private int limitPerRowPerCf = -1;
    private int offsetPerRowPerCf = 0;
    private String filterString;

    @Override
    public byte[] encode() {
        byte[] bytes = new byte[(int)this.getPayloadSize()];
        int idx = 0;
        int headerLen = (int)Serialization.getObUniVersionHeaderLength(this.getVersion(), this.getPayloadContentSize());
        System.arraycopy(Serialization.encodeObUniVersionHeader(this.getVersion(), this.getPayloadContentSize()), 0, bytes, idx, headerLen);
        System.arraycopy(Serialization.encodeI8(this.isValid ? (byte)1 : 0), 0, bytes, idx += headerLen, 1);
        int len = Serialization.getNeedBytes(this.selectColumnQualifier.size());
        System.arraycopy(Serialization.encodeVi64(this.selectColumnQualifier.size()), 0, bytes, ++idx, len);
        idx += len;
        for (ObBytesString q : this.selectColumnQualifier) {
            len = Serialization.getNeedBytes(q);
            System.arraycopy(Serialization.encodeBytesString(q), 0, bytes, idx, len);
            idx += len;
        }
        len = Serialization.getNeedBytes(this.minStamp);
        System.arraycopy(Serialization.encodeVi64(this.minStamp), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.maxStamp);
        System.arraycopy(Serialization.encodeVi64(this.maxStamp), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.maxVersions);
        System.arraycopy(Serialization.encodeVi32(this.maxVersions), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.limitPerRowPerCf);
        System.arraycopy(Serialization.encodeVi32(this.limitPerRowPerCf), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.offsetPerRowPerCf);
        System.arraycopy(Serialization.encodeVi32(this.offsetPerRowPerCf), 0, bytes, idx, len);
        idx += len;
        len = Serialization.getNeedBytes(this.filterString);
        System.arraycopy(Serialization.encodeVString(this.filterString), 0, bytes, idx, len);
        idx += len;
        return bytes;
    }

    @Override
    public Object decode(ByteBuf buf) {
        super.decode(buf);
        this.isValid = Serialization.decodeI8(buf) == 1;
        long size = Serialization.decodeVi64(buf);
        this.selectColumnQualifier = new ArrayList<ObBytesString>((int)size);
        int i = 0;
        while ((long)i < size) {
            this.selectColumnQualifier.add(Serialization.decodeBytesString(buf));
            ++i;
        }
        this.minStamp = Serialization.decodeVi64(buf);
        this.maxStamp = Serialization.decodeVi64(buf);
        this.maxVersions = Serialization.decodeVi32(buf);
        this.limitPerRowPerCf = Serialization.decodeVi32(buf);
        this.offsetPerRowPerCf = Serialization.decodeVi32(buf);
        this.filterString = Serialization.decodeVString(buf);
        return this;
    }

    @Override
    public long getPayloadContentSize() {
        long contentSize = 0L;
        ++contentSize;
        contentSize += (long)Serialization.getNeedBytes(this.selectColumnQualifier.size());
        for (ObBytesString q : this.selectColumnQualifier) {
            contentSize += (long)Serialization.getNeedBytes(q);
        }
        contentSize += (long)Serialization.getNeedBytes(this.minStamp);
        contentSize += (long)Serialization.getNeedBytes(this.maxStamp);
        contentSize += (long)Serialization.getNeedBytes(this.maxVersions);
        contentSize += (long)Serialization.getNeedBytes(this.limitPerRowPerCf);
        contentSize += (long)Serialization.getNeedBytes(this.offsetPerRowPerCf);
        return contentSize += (long)Serialization.getNeedBytes(this.filterString);
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean valid) {
        this.isValid = valid;
    }

    public List<ObBytesString> getSelectColumnQualifier() {
        return this.selectColumnQualifier;
    }

    public void addSelectColumnQualifier(String selectColumnQualifier) {
        this.selectColumnQualifier.add(new ObBytesString(selectColumnQualifier));
    }

    public void addSelectColumnQualifier(byte[] selectColumnQualifier) {
        this.selectColumnQualifier.add(new ObBytesString(selectColumnQualifier));
    }

    public void setSelectColumnQualifier(List<ObBytesString> selectColumnQualifier) {
        this.selectColumnQualifier = selectColumnQualifier;
    }

    public long getMinStamp() {
        return this.minStamp;
    }

    public void setMinStamp(long minStamp) {
        this.minStamp = minStamp;
    }

    public long getMaxStamp() {
        return this.maxStamp;
    }

    public void setMaxStamp(long maxStamp) {
        this.maxStamp = maxStamp;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public void setMaxVersions(int maxVersions) {
        this.maxVersions = maxVersions;
    }

    public int getLimitPerRowPerCf() {
        return this.limitPerRowPerCf;
    }

    public void setLimitPerRowPerCf(int limitPerRowPerCf) {
        this.limitPerRowPerCf = limitPerRowPerCf;
    }

    public int getOffsetPerRowPerCf() {
        return this.offsetPerRowPerCf;
    }

    public void setOffsetPerRowPerCf(int offsetPerRowPerCf) {
        this.offsetPerRowPerCf = offsetPerRowPerCf;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }
}

