/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.protocol.payload.ObSimplePayload;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.table.ObDirectLoadObjRow;
import com.alipay.oceanbase.rpc.util.ObByteBuf;
import com.alipay.oceanbase.rpc.util.Serialization;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class ObDirectLoadBucket
implements ObSimplePayload {
    private ArrayList<ObDirectLoadObjRow> rowList = new ArrayList();

    public boolean isEmpty() {
        return this.rowList.isEmpty();
    }

    public int getRowCount() {
        return this.rowList.size();
    }

    public void addRow(ObObj[] row) {
        this.rowList.add(new ObDirectLoadObjRow(row));
    }

    public void addRow(List<ObObj> row) {
        this.rowList.add(new ObDirectLoadObjRow(row));
    }

    public void addRow(ObDirectLoadObjRow row) {
        if (row == null) {
            throw new NullPointerException();
        }
        this.rowList.add(row);
    }

    @Override
    public byte[] encode() {
        int needBytes = this.getEncodedSize();
        ObByteBuf buf = new ObByteBuf(needBytes);
        this.encode(buf);
        return buf.bytes;
    }

    @Override
    public void encode(ObByteBuf buf) {
        Serialization.encodeVi32(buf, this.rowList.size());
        for (int i = 0; i < this.rowList.size(); ++i) {
            this.rowList.get(i).encode(buf);
        }
    }

    @Override
    public ObDirectLoadBucket decode(ByteBuf buf) {
        int count = Serialization.decodeVi32(buf);
        for (int i = 0; i < count; ++i) {
            ObDirectLoadObjRow row = new ObDirectLoadObjRow();
            row.decode(buf);
            this.rowList.add(row);
        }
        return this;
    }

    @Override
    public int getEncodedSize() {
        int size = 0;
        size += Serialization.getNeedBytes(this.rowList.size());
        for (int i = 0; i < this.rowList.size(); ++i) {
            size += this.rowList.get(i).getEncodedSize();
        }
        return size;
    }
}

