/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.property.AbstractPropertyAware;
import com.alipay.oceanbase.rpc.property.Property;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.ObSimplePayload;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObAddr;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObTableDirectLoadAbortArg;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObTableDirectLoadBeginArg;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObTableDirectLoadBeginRes;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObTableDirectLoadCommitArg;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObTableDirectLoadGetStatusArg;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObTableDirectLoadGetStatusRes;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObTableDirectLoadHeartBeatArg;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObTableDirectLoadHeartBeatRes;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObTableDirectLoadInsertArg;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObTableDirectLoadOperationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObTableDirectLoadRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObTableDirectLoadResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.direct_load.ObTableLoadClientStatus;
import com.alipay.oceanbase.rpc.table.ObDirectLoadBucket;
import com.alipay.oceanbase.rpc.table.ObDirectLoadParameter;
import com.alipay.oceanbase.rpc.table.ObTable;
import com.alipay.oceanbase.rpc.util.ObBytesString;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;

public class ObTableDirectLoad
extends AbstractPropertyAware {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObTableDirectLoad.class);
    private ObTable table = null;
    private String tableName;
    private ObDirectLoadParameter parameter = null;
    private boolean forceCreate = false;
    private long tableId = 0L;
    private long taskId = 0L;
    private String[] columnNames = new String[0];
    private ObTableLoadClientStatus status = ObTableLoadClientStatus.MAX_STATUS;
    private int errorCode;
    private ObAddr srvAddr;
    private Timer timer;
    protected int runtimeRetryTimes;
    protected int runtimeRetryInterval;

    public ObTableDirectLoad(ObTable table, String tableName, ObDirectLoadParameter parameter, boolean forceCreate) {
        this.errorCode = ResultCodes.OB_SUCCESS.errorCode;
        this.srvAddr = null;
        this.runtimeRetryTimes = Property.RUNTIME_RETRY_TIMES.getDefaultInt();
        this.runtimeRetryInterval = Property.RUNTIME_RETRY_INTERVAL.getDefaultInt();
        if (ObGlobal.OB_VERSION < ObGlobal.OB_VERSION_4_2_1_0) {
            logger.warn("not supported ob version {}", (Object)ObGlobal.obVsnString());
            throw new ObTableException("not supported ob version " + ObGlobal.obVsnString(), ResultCodes.OB_NOT_SUPPORTED.errorCode);
        }
        if (table == null || tableName == null || tableName.isEmpty() || parameter == null) {
            logger.warn("invalid args, table:{}, tableName:{}, parameter:{}", new Object[]{table, tableName, parameter});
            throw new IllegalArgumentException("invalid args: " + table + ", " + tableName + ", " + parameter);
        }
        this.table = table;
        this.tableName = tableName;
        this.parameter = parameter;
        this.forceCreate = forceCreate;
        this.initProperties();
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
        this.initProperties();
    }

    public ObTable getTable() {
        return this.table;
    }

    public String getTableName() {
        return this.tableName;
    }

    public ObDirectLoadParameter getParameter() {
        return this.parameter;
    }

    public long getTableId() {
        return this.tableId;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public boolean isAvailable() {
        return this.status != ObTableLoadClientStatus.MAX_STATUS;
    }

    public boolean isRunning() {
        return this.status == ObTableLoadClientStatus.RUNNING;
    }

    public boolean isCommitting() {
        return this.status == ObTableLoadClientStatus.COMMITTING;
    }

    public boolean isCommit() {
        return this.status == ObTableLoadClientStatus.COMMIT;
    }

    public boolean isError() {
        return this.status == ObTableLoadClientStatus.ERROR;
    }

    public boolean isAbort() {
        return this.status == ObTableLoadClientStatus.ABORT;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public ObAddr getSrvAddr() {
        return this.srvAddr;
    }

    public String toString() {
        return String.format("{tableName:%s, tableId:%d, taskId:%d}", this.tableName, this.tableId, this.taskId);
    }

    private void initProperties() {
        this.runtimeRetryTimes = this.parseToInt(Property.RUNTIME_RETRY_TIMES.getKey(), this.runtimeRetryTimes);
        this.runtimeRetryInterval = this.parseToInt(Property.RUNTIME_RETRY_INTERVAL.getKey(), this.runtimeRetryInterval);
    }

    public void begin() throws Exception {
        if (this.status != ObTableLoadClientStatus.MAX_STATUS) {
            logger.warn("unexpected status to begin, table:{}, status:{}", (Object)this, (Object)this.status);
            throw new ObTableException("unexpected status to begin, status:" + (Object)((Object)this.status), ResultCodes.OB_STATE_NOT_MATCH.errorCode);
        }
        ObTableDirectLoadBeginArg arg = new ObTableDirectLoadBeginArg();
        ObTableDirectLoadBeginRes res = new ObTableDirectLoadBeginRes();
        arg.setTableName(this.tableName);
        arg.setParallel(this.parameter.getParallel());
        arg.setMaxErrorRowCount(this.parameter.getMaxErrorRowCount());
        arg.setDupAction(this.parameter.getDupAction());
        arg.setTimeout(this.parameter.getTimeout());
        arg.setHeartBeatTimeout(this.parameter.getHeartBeatTimeout());
        arg.setForceCreate(this.forceCreate);
        this.execute(ObTableDirectLoadOperationType.BEGIN, arg, res);
        this.tableId = res.getTableId();
        this.taskId = res.getTaskId();
        this.columnNames = res.getColumnNames();
        this.status = res.getStatus();
        this.errorCode = res.getErrorCode();
        logger.info("begin suceess, table:{}", (Object)this);
        this.startHeartBeat();
    }

    public void commit() throws Exception {
        if (!this.isRunning()) {
            logger.warn("unexpected status to commit, table:{}, status:{}", (Object)this, (Object)this.status);
            throw new ObTableException("unexpected status to commit, status:" + (Object)((Object)this.status), ResultCodes.OB_STATE_NOT_MATCH.errorCode);
        }
        ObTableDirectLoadCommitArg arg = new ObTableDirectLoadCommitArg();
        arg.setTableId(this.tableId);
        arg.setTaskId(this.taskId);
        this.execute(ObTableDirectLoadOperationType.COMMIT, arg);
        logger.info("commit suceess, table:{}", (Object)this);
    }

    public void abort() throws Exception {
        if (this.status == ObTableLoadClientStatus.MAX_STATUS) {
            logger.warn("unexpected status to abort, table:{}, status:{}", (Object)this, (Object)this.status);
            throw new ObTableException("unexpected status to abort, status:" + (Object)((Object)this.status), ResultCodes.OB_STATE_NOT_MATCH.errorCode);
        }
        if (this.isAbort()) {
            return;
        }
        ObTableDirectLoadAbortArg arg = new ObTableDirectLoadAbortArg();
        arg.setTableId(this.tableId);
        arg.setTaskId(this.taskId);
        this.execute(ObTableDirectLoadOperationType.ABORT, arg);
        logger.info("abort suceess, table:{}", (Object)this);
        this.stopHeartBeat();
    }

    public ObTableLoadClientStatus getStatus() throws Exception {
        if (this.status == ObTableLoadClientStatus.MAX_STATUS) {
            logger.warn("unexpected status to get status, table:{}, status:{}", (Object)this, (Object)this.status);
            throw new ObTableException("unexpected status to get status, status:" + (Object)((Object)this.status), ResultCodes.OB_STATE_NOT_MATCH.errorCode);
        }
        ObTableDirectLoadGetStatusArg arg = new ObTableDirectLoadGetStatusArg();
        ObTableDirectLoadGetStatusRes res = new ObTableDirectLoadGetStatusRes();
        arg.setTableId(this.tableId);
        arg.setTaskId(this.taskId);
        this.execute(ObTableDirectLoadOperationType.GET_STATUS, arg, res);
        this.status = res.getStatus();
        this.errorCode = res.getErrorCode();
        return this.status;
    }

    public void insert(ObDirectLoadBucket bucket) throws Exception {
        if (!this.isRunning()) {
            logger.warn("unexpected status to insert, table:{}, status:{}", (Object)this, (Object)this.status);
            throw new ObTableException("unexpected status to insert, status:" + (Object)((Object)this.status), ResultCodes.OB_STATE_NOT_MATCH.errorCode);
        }
        ObTableDirectLoadInsertArg arg = new ObTableDirectLoadInsertArg();
        arg.setTableId(this.tableId);
        arg.setTaskId(this.taskId);
        arg.setPayload(new ObBytesString(bucket.encode()));
        this.execute(ObTableDirectLoadOperationType.INSERT, arg);
    }

    private void heartBeat() throws Exception {
        ObTableDirectLoadHeartBeatArg arg = new ObTableDirectLoadHeartBeatArg();
        ObTableDirectLoadHeartBeatRes res = new ObTableDirectLoadHeartBeatRes();
        arg.setTableId(this.tableId);
        arg.setTaskId(this.taskId);
        this.execute(ObTableDirectLoadOperationType.HEART_BEAT, arg, res);
        this.status = res.getStatus();
        this.errorCode = res.getErrorCode();
    }

    private void startHeartBeat() {
        this.timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    ObTableDirectLoad.this.heartBeat();
                }
                catch (Exception e) {
                    ObTableDirectLoad.this.stopHeartBeat();
                    logger.info(String.format("heart beat failed, table:%s", this), (Throwable)e);
                }
            }
        };
        this.timer.schedule(task, 0L, 10000L);
        logger.info("start heart beat, table:{}", (Object)this);
    }

    private void stopHeartBeat() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        logger.info("stop heart beat, table:{}", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(ObTableDirectLoadOperationType operationType, ObSimplePayload arg, ObSimplePayload res) throws Exception {
        ObTableDirectLoadRequest request = new ObTableDirectLoadRequest();
        ObTableDirectLoadRequest.Header header = new ObTableDirectLoadRequest.Header();
        if (operationType != ObTableDirectLoadOperationType.BEGIN) {
            header.setAddr(this.srvAddr);
        }
        header.setOperationType(operationType);
        request.setHeader(header);
        request.setArgContent(new ObBytesString(arg.encode()));
        ObTableDirectLoadResult result = (ObTableDirectLoadResult)this.rpcCall(request);
        if (result.getHeader().getOperationType() != operationType) {
            logger.warn("unexpected result operation type, table:{}, reqOpType:{}, resOpType:{}", new Object[]{this, operationType, result.getHeader().getOperationType()});
            throw new ObTableException("unexpected result operation type:" + (Object)((Object)result.getHeader().getOperationType()) + ", request operation type:" + (Object)((Object)operationType), ResultCodes.OB_ERR_UNEXPECTED.errorCode);
        }
        if (result.getResContent().length() == 0) {
            logger.warn("unexpected empty res content, table:{}, OpType:{}", (Object)this, (Object)operationType);
            throw new ObTableException("unexpected empty res content", ResultCodes.OB_ERR_UNEXPECTED.errorCode);
        }
        if (operationType == ObTableDirectLoadOperationType.BEGIN) {
            this.srvAddr = result.getHeader().getAddr();
        }
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(result.getResContent().length());
        try {
            buf.writeBytes(result.getResContent().bytes);
            res.decode(buf);
        }
        finally {
            buf.release();
        }
    }

    private void execute(ObTableDirectLoadOperationType operationType, ObSimplePayload arg) throws Exception {
        ObTableDirectLoadRequest request = new ObTableDirectLoadRequest();
        ObTableDirectLoadRequest.Header header = new ObTableDirectLoadRequest.Header();
        if (operationType != ObTableDirectLoadOperationType.BEGIN) {
            header.setAddr(this.srvAddr);
        }
        header.setOperationType(operationType);
        request.setHeader(header);
        request.setArgContent(new ObBytesString(arg.encode()));
        ObTableDirectLoadResult result = (ObTableDirectLoadResult)this.rpcCall(request);
        if (result.getHeader().getOperationType() != operationType) {
            logger.warn("unexpected result operation type, table:{}, reqOpType:{}, resOpType:{}", new Object[]{this, operationType, result.getHeader().getOperationType()});
            throw new ObTableException("unexpected result operation type:" + (Object)((Object)result.getHeader().getOperationType()) + ", request operation type:" + (Object)((Object)operationType), ResultCodes.OB_ERR_UNEXPECTED.errorCode);
        }
        if (result.getResContent().length() != 0) {
            logger.warn("unexpected res content not empty, table:{}, OpType:{}", (Object)this, (Object)operationType);
            throw new ObTableException("unexpected res content not empty", ResultCodes.OB_ERR_UNEXPECTED.errorCode);
        }
    }

    private ObPayload rpcCall(ObTableDirectLoadRequest request) throws Exception {
        int tries = 0;
        while (true) {
            try {
                request.setTimeout(this.table.getObTableExecuteTimeout());
                return this.table.execute(request);
            }
            catch (Exception e) {
                logger.warn(String.format("table execute failed, table:%s, tries:%d, request:%s", this, tries, request), (Throwable)e);
                if (tries >= this.runtimeRetryTimes) {
                    throw e;
                }
                Thread.sleep(this.runtimeRetryInterval);
                ++tries;
                continue;
            }
            break;
        }
    }
}

